package odata.msgraph.client.beta.container;

import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.TestingService.BuilderBase;
import com.github.davidmoten.odata.client.TestingService.ContainerBuilder;

import odata.msgraph.client.beta.entity.request.AccessReviewDecisionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewRequest;
import odata.msgraph.client.beta.entity.request.ActivityStatisticsRequest;
import odata.msgraph.client.beta.entity.request.AdministrativeUnitRequest;
import odata.msgraph.client.beta.entity.request.AgreementAcceptanceRequest;
import odata.msgraph.client.beta.entity.request.AgreementRequest;
import odata.msgraph.client.beta.entity.request.AllowedDataLocationRequest;
import odata.msgraph.client.beta.entity.request.AppCatalogsRequest;
import odata.msgraph.client.beta.entity.request.AppRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ApplicationRequest;
import odata.msgraph.client.beta.entity.request.ApplicationTemplateRequest;
import odata.msgraph.client.beta.entity.request.ApprovalWorkflowProviderRequest;
import odata.msgraph.client.beta.entity.request.AttributeMappingFunctionSchemaRequest;
import odata.msgraph.client.beta.entity.request.AuditLogRootRequest;
import odata.msgraph.client.beta.entity.request.BitlockerRequest;
import odata.msgraph.client.beta.entity.request.BookingBusinessRequest;
import odata.msgraph.client.beta.entity.request.BookingCurrencyRequest;
import odata.msgraph.client.beta.entity.request.BusinessFlowTemplateRequest;
import odata.msgraph.client.beta.entity.request.CertificateBasedAuthConfigurationRequest;
import odata.msgraph.client.beta.entity.request.ChatRequest;
import odata.msgraph.client.beta.entity.request.CloudCommunicationsRequest;
import odata.msgraph.client.beta.entity.request.CommandRequest;
import odata.msgraph.client.beta.entity.request.CommsApplicationRequest;
import odata.msgraph.client.beta.entity.request.ComplianceRequest;
import odata.msgraph.client.beta.entity.request.ConditionalAccessRootRequest;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.ConnectorRequest;
import odata.msgraph.client.beta.entity.request.ContractRequest;
import odata.msgraph.client.beta.entity.request.DataClassificationServiceRequest;
import odata.msgraph.client.beta.entity.request.DataPolicyOperationRequest;
import odata.msgraph.client.beta.entity.request.DeviceAppManagementRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementRequest;
import odata.msgraph.client.beta.entity.request.DeviceRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRoleRequest;
import odata.msgraph.client.beta.entity.request.DirectoryRoleTemplateRequest;
import odata.msgraph.client.beta.entity.request.DirectorySettingRequest;
import odata.msgraph.client.beta.entity.request.DirectorySettingTemplateRequest;
import odata.msgraph.client.beta.entity.request.DomainDnsRecordRequest;
import odata.msgraph.client.beta.entity.request.DomainRequest;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.EdiscoveryCaseRequest;
import odata.msgraph.client.beta.entity.request.EducationRootRequest;
import odata.msgraph.client.beta.entity.request.ExternalConnectionRequest;
import odata.msgraph.client.beta.entity.request.ExternalRequest;
import odata.msgraph.client.beta.entity.request.FilterOperatorSchemaRequest;
import odata.msgraph.client.beta.entity.request.FinancialsRequest;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleSettingRequest;
import odata.msgraph.client.beta.entity.request.GovernanceSubjectRequest;
import odata.msgraph.client.beta.entity.request.GroupLifecyclePolicyRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.IdentityContainerRequest;
import odata.msgraph.client.beta.entity.request.IdentityGovernanceRequest;
import odata.msgraph.client.beta.entity.request.IdentityProtectionRootRequest;
import odata.msgraph.client.beta.entity.request.IdentityProviderRequest;
import odata.msgraph.client.beta.entity.request.InformationProtectionRequest;
import odata.msgraph.client.beta.entity.request.InvitationRequest;
import odata.msgraph.client.beta.entity.request.OAuth2PermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.OfficeConfigurationRequest;
import odata.msgraph.client.beta.entity.request.OnPremisesPublishingProfileRequest;
import odata.msgraph.client.beta.entity.request.OrgContactRequest;
import odata.msgraph.client.beta.entity.request.OrganizationRequest;
import odata.msgraph.client.beta.entity.request.PayloadResponseRequest;
import odata.msgraph.client.beta.entity.request.PlaceRequest;
import odata.msgraph.client.beta.entity.request.PlannerRequest;
import odata.msgraph.client.beta.entity.request.PolicyRootRequest;
import odata.msgraph.client.beta.entity.request.PrintRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedAccessRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedApprovalRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedOperationEventRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedSignupStatusRequest;
import odata.msgraph.client.beta.entity.request.ProgramControlRequest;
import odata.msgraph.client.beta.entity.request.ProgramControlTypeRequest;
import odata.msgraph.client.beta.entity.request.ProgramRequest;
import odata.msgraph.client.beta.entity.request.ReportRootRequest;
import odata.msgraph.client.beta.entity.request.ResourceSpecificPermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.RiskDetectionRequest;
import odata.msgraph.client.beta.entity.request.RiskyUserRequest;
import odata.msgraph.client.beta.entity.request.RoleManagementRequest;
import odata.msgraph.client.beta.entity.request.SchemaExtensionRequest;
import odata.msgraph.client.beta.entity.request.ScopedRoleMembershipRequest;
import odata.msgraph.client.beta.entity.request.SearchRequest;
import odata.msgraph.client.beta.entity.request.SecurityRequest;
import odata.msgraph.client.beta.entity.request.ServicePrincipalRequest;
import odata.msgraph.client.beta.entity.request.SharedDriveItemRequest;
import odata.msgraph.client.beta.entity.request.SiteRequest;
import odata.msgraph.client.beta.entity.request.SubscribedSkuRequest;
import odata.msgraph.client.beta.entity.request.SubscriptionRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.entity.request.TeamsTemplateRequest;
import odata.msgraph.client.beta.entity.request.TeamworkRequest;
import odata.msgraph.client.beta.entity.request.TrustFrameworkRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.entity.set.AccessReviewDecisions;
import odata.msgraph.client.beta.entity.set.AccessReviews;
import odata.msgraph.client.beta.entity.set.Activitystatistics;
import odata.msgraph.client.beta.entity.set.AdministrativeUnits;
import odata.msgraph.client.beta.entity.set.AgreementAcceptances;
import odata.msgraph.client.beta.entity.set.Agreements;
import odata.msgraph.client.beta.entity.set.AllowedDataLocations;
import odata.msgraph.client.beta.entity.set.AppRoleAssignments;
import odata.msgraph.client.beta.entity.set.ApplicationTemplates;
import odata.msgraph.client.beta.entity.set.Applications;
import odata.msgraph.client.beta.entity.set.ApprovalWorkflowProviders;
import odata.msgraph.client.beta.entity.set.BookingBusinesses;
import odata.msgraph.client.beta.entity.set.BookingCurrencies;
import odata.msgraph.client.beta.entity.set.BusinessFlowTemplates;
import odata.msgraph.client.beta.entity.set.Cases;
import odata.msgraph.client.beta.entity.set.CertificateBasedAuthConfiguration;
import odata.msgraph.client.beta.entity.set.Chats;
import odata.msgraph.client.beta.entity.set.Commands;
import odata.msgraph.client.beta.entity.set.Connections;
import odata.msgraph.client.beta.entity.set.ConnectorGroups;
import odata.msgraph.client.beta.entity.set.Connectors;
import odata.msgraph.client.beta.entity.set.Contacts;
import odata.msgraph.client.beta.entity.set.Contracts;
import odata.msgraph.client.beta.entity.set.DataPolicyOperations;
import odata.msgraph.client.beta.entity.set.Devices;
import odata.msgraph.client.beta.entity.set.DirectoryObjects;
import odata.msgraph.client.beta.entity.set.DirectoryRoleTemplates;
import odata.msgraph.client.beta.entity.set.DirectoryRoles;
import odata.msgraph.client.beta.entity.set.DirectorySettingTemplates;
import odata.msgraph.client.beta.entity.set.DomainDnsRecords;
import odata.msgraph.client.beta.entity.set.Domains;
import odata.msgraph.client.beta.entity.set.Drives;
import odata.msgraph.client.beta.entity.set.FilterOperators;
import odata.msgraph.client.beta.entity.set.Functions;
import odata.msgraph.client.beta.entity.set.GovernanceResources;
import odata.msgraph.client.beta.entity.set.GovernanceRoleAssignmentRequests;
import odata.msgraph.client.beta.entity.set.GovernanceRoleAssignments;
import odata.msgraph.client.beta.entity.set.GovernanceRoleDefinitions;
import odata.msgraph.client.beta.entity.set.GovernanceRoleSettings;
import odata.msgraph.client.beta.entity.set.GovernanceSubjects;
import odata.msgraph.client.beta.entity.set.GroupLifecyclePolicies;
import odata.msgraph.client.beta.entity.set.Groups;
import odata.msgraph.client.beta.entity.set.IdentityProviders;
import odata.msgraph.client.beta.entity.set.Invitations;
import odata.msgraph.client.beta.entity.set.Oauth2PermissionGrants;
import odata.msgraph.client.beta.entity.set.OnPremisesPublishingProfiles;
import odata.msgraph.client.beta.entity.set.Organization;
import odata.msgraph.client.beta.entity.set.PayloadResponse;
import odata.msgraph.client.beta.entity.set.PermissionGrants;
import odata.msgraph.client.beta.entity.set.Places;
import odata.msgraph.client.beta.entity.set.PrivilegedAccess;
import odata.msgraph.client.beta.entity.set.PrivilegedApproval;
import odata.msgraph.client.beta.entity.set.PrivilegedOperationEvents;
import odata.msgraph.client.beta.entity.set.PrivilegedRoleAssignmentRequests;
import odata.msgraph.client.beta.entity.set.PrivilegedRoleAssignments;
import odata.msgraph.client.beta.entity.set.PrivilegedRoles;
import odata.msgraph.client.beta.entity.set.PrivilegedSignupStatus;
import odata.msgraph.client.beta.entity.set.ProgramControlTypes;
import odata.msgraph.client.beta.entity.set.ProgramControls;
import odata.msgraph.client.beta.entity.set.Programs;
import odata.msgraph.client.beta.entity.set.RiskDetections;
import odata.msgraph.client.beta.entity.set.RiskyUsers;
import odata.msgraph.client.beta.entity.set.SchemaExtensions;
import odata.msgraph.client.beta.entity.set.ScopedRoleMemberships;
import odata.msgraph.client.beta.entity.set.ServicePrincipals;
import odata.msgraph.client.beta.entity.set.Settings;
import odata.msgraph.client.beta.entity.set.Shares;
import odata.msgraph.client.beta.entity.set.Sites;
import odata.msgraph.client.beta.entity.set.SubscribedSkus;
import odata.msgraph.client.beta.entity.set.Subscriptions;
import odata.msgraph.client.beta.entity.set.Teams;
import odata.msgraph.client.beta.entity.set.TeamsTemplates;
import odata.msgraph.client.beta.entity.set.Users;
import odata.msgraph.client.beta.entity.set.Workbooks;

public final class GraphService implements HasContext {

    private final ContextPath contextPath;

    public GraphService(Context context) {
        this.contextPath = new ContextPath(context, context.service().getBasePath());
    }

    @Override
    public Context _context() {
        return contextPath.context();
    }

    public HttpService _service() {
        return contextPath.context().service();
    }

    static final class ContainerBuilderImpl extends ContainerBuilder<GraphService> {

        @Override
        public GraphService _create(Context context) {
            return new GraphService(context);
        }
    }

    public static BuilderBase<ContainerBuilder<GraphService>, GraphService> test() {
        return new ContainerBuilderImpl();
    }

    public Invitations invitations() {
        return new Invitations(
                        contextPath.addSegment("invitations"));
    }

    public InvitationRequest invitations(String id) {
        return new InvitationRequest(contextPath.addSegment("invitations").addKeys(new NameValue(id.toString())));
    }

    public Users users() {
        return new Users(
                        contextPath.addSegment("users"));
    }

    public UserRequest users(String id) {
        return new UserRequest(contextPath.addSegment("users").addKeys(new NameValue(id.toString())));
    }

    public Activitystatistics activitystatistics() {
        return new Activitystatistics(
                        contextPath.addSegment("activitystatistics"));
    }

    public ActivityStatisticsRequest activitystatistics(String id) {
        return new ActivityStatisticsRequest(contextPath.addSegment("activitystatistics").addKeys(new NameValue(id.toString())));
    }

    public ApplicationTemplates applicationTemplates() {
        return new ApplicationTemplates(
                        contextPath.addSegment("applicationTemplates"));
    }

    public ApplicationTemplateRequest applicationTemplates(String id) {
        return new ApplicationTemplateRequest(contextPath.addSegment("applicationTemplates").addKeys(new NameValue(id.toString())));
    }

    public BookingBusinesses bookingBusinesses() {
        return new BookingBusinesses(
                        contextPath.addSegment("bookingBusinesses"));
    }

    public BookingBusinessRequest bookingBusinesses(String id) {
        return new BookingBusinessRequest(contextPath.addSegment("bookingBusinesses").addKeys(new NameValue(id.toString())));
    }

    public BookingCurrencies bookingCurrencies() {
        return new BookingCurrencies(
                        contextPath.addSegment("bookingCurrencies"));
    }

    public BookingCurrencyRequest bookingCurrencies(String id) {
        return new BookingCurrencyRequest(contextPath.addSegment("bookingCurrencies").addKeys(new NameValue(id.toString())));
    }

    public IdentityProviders identityProviders() {
        return new IdentityProviders(
                        contextPath.addSegment("identityProviders"));
    }

    public IdentityProviderRequest identityProviders(String id) {
        return new IdentityProviderRequest(contextPath.addSegment("identityProviders").addKeys(new NameValue(id.toString())));
    }

    public Cases cases() {
        return new Cases(
                        contextPath.addSegment("cases"));
    }

    public EdiscoveryCaseRequest cases(String id) {
        return new EdiscoveryCaseRequest(contextPath.addSegment("cases").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjects directoryObjects() {
        return new DirectoryObjects(
                        contextPath.addSegment("directoryObjects"));
    }

    public DirectoryObjectRequest directoryObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryObjects").addKeys(new NameValue(id.toString())));
    }

    public Applications applications() {
        return new Applications(
                        contextPath.addSegment("applications"));
    }

    public ApplicationRequest applications(String id) {
        return new ApplicationRequest(contextPath.addSegment("applications").addKeys(new NameValue(id.toString())));
    }

    public PermissionGrants permissionGrants() {
        return new PermissionGrants(
                        contextPath.addSegment("permissionGrants"));
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id.toString())));
    }

    public AdministrativeUnits administrativeUnits() {
        return new AdministrativeUnits(
                        contextPath.addSegment("administrativeUnits"));
    }

    public AdministrativeUnitRequest administrativeUnits(String id) {
        return new AdministrativeUnitRequest(contextPath.addSegment("administrativeUnits").addKeys(new NameValue(id.toString())));
    }

    public AllowedDataLocations allowedDataLocations() {
        return new AllowedDataLocations(
                        contextPath.addSegment("allowedDataLocations"));
    }

    public AllowedDataLocationRequest allowedDataLocations(String id) {
        return new AllowedDataLocationRequest(contextPath.addSegment("allowedDataLocations").addKeys(new NameValue(id.toString())));
    }

    public AppRoleAssignments appRoleAssignments() {
        return new AppRoleAssignments(
                        contextPath.addSegment("appRoleAssignments"));
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public CertificateBasedAuthConfiguration certificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfiguration(
                        contextPath.addSegment("certificateBasedAuthConfiguration"));
    }

    public CertificateBasedAuthConfigurationRequest certificateBasedAuthConfiguration(String id) {
        return new CertificateBasedAuthConfigurationRequest(contextPath.addSegment("certificateBasedAuthConfiguration").addKeys(new NameValue(id.toString())));
    }

    public Contacts contacts() {
        return new Contacts(
                        contextPath.addSegment("contacts"));
    }

    public OrgContactRequest contacts(String id) {
        return new OrgContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(id.toString())));
    }

    public Devices devices() {
        return new Devices(
                        contextPath.addSegment("devices"));
    }

    public DeviceRequest devices(String id) {
        return new DeviceRequest(contextPath.addSegment("devices").addKeys(new NameValue(id.toString())));
    }

    public Domains domains() {
        return new Domains(
                        contextPath.addSegment("domains"));
    }

    public DomainRequest domains(String id) {
        return new DomainRequest(contextPath.addSegment("domains").addKeys(new NameValue(id.toString())));
    }

    public DomainDnsRecords domainDnsRecords() {
        return new DomainDnsRecords(
                        contextPath.addSegment("domainDnsRecords"));
    }

    public DomainDnsRecordRequest domainDnsRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("domainDnsRecords").addKeys(new NameValue(id.toString())));
    }

    public Groups groups() {
        return new Groups(
                        contextPath.addSegment("groups"));
    }

    public GroupRequest groups(String id) {
        return new GroupRequest(contextPath.addSegment("groups").addKeys(new NameValue(id.toString())));
    }

    public DirectoryRoles directoryRoles() {
        return new DirectoryRoles(
                        contextPath.addSegment("directoryRoles"));
    }

    public DirectoryRoleRequest directoryRoles(String id) {
        return new DirectoryRoleRequest(contextPath.addSegment("directoryRoles").addKeys(new NameValue(id.toString())));
    }

    public DirectoryRoleTemplates directoryRoleTemplates() {
        return new DirectoryRoleTemplates(
                        contextPath.addSegment("directoryRoleTemplates"));
    }

    public DirectoryRoleTemplateRequest directoryRoleTemplates(String id) {
        return new DirectoryRoleTemplateRequest(contextPath.addSegment("directoryRoleTemplates").addKeys(new NameValue(id.toString())));
    }

    public DirectorySettingTemplates directorySettingTemplates() {
        return new DirectorySettingTemplates(
                        contextPath.addSegment("directorySettingTemplates"));
    }

    public DirectorySettingTemplateRequest directorySettingTemplates(String id) {
        return new DirectorySettingTemplateRequest(contextPath.addSegment("directorySettingTemplates").addKeys(new NameValue(id.toString())));
    }

    public Organization organization() {
        return new Organization(
                        contextPath.addSegment("organization"));
    }

    public OrganizationRequest organization(String id) {
        return new OrganizationRequest(contextPath.addSegment("organization").addKeys(new NameValue(id.toString())));
    }

    public Oauth2PermissionGrants oauth2PermissionGrants() {
        return new Oauth2PermissionGrants(
                        contextPath.addSegment("oauth2PermissionGrants"));
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id.toString())));
    }

    public ScopedRoleMemberships scopedRoleMemberships() {
        return new ScopedRoleMemberships(
                        contextPath.addSegment("scopedRoleMemberships"));
    }

    public ScopedRoleMembershipRequest scopedRoleMemberships(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMemberships").addKeys(new NameValue(id.toString())));
    }

    public ServicePrincipals servicePrincipals() {
        return new ServicePrincipals(
                        contextPath.addSegment("servicePrincipals"));
    }

    public ServicePrincipalRequest servicePrincipals(String id) {
        return new ServicePrincipalRequest(contextPath.addSegment("servicePrincipals").addKeys(new NameValue(id.toString())));
    }

    public Settings settings() {
        return new Settings(
                        contextPath.addSegment("settings"));
    }

    public DirectorySettingRequest settings(String id) {
        return new DirectorySettingRequest(contextPath.addSegment("settings").addKeys(new NameValue(id.toString())));
    }

    public SubscribedSkus subscribedSkus() {
        return new SubscribedSkus(
                        contextPath.addSegment("subscribedSkus"));
    }

    public SubscribedSkuRequest subscribedSkus(String id) {
        return new SubscribedSkuRequest(contextPath.addSegment("subscribedSkus").addKeys(new NameValue(id.toString())));
    }

    public Contracts contracts() {
        return new Contracts(
                        contextPath.addSegment("contracts"));
    }

    public ContractRequest contracts(String id) {
        return new ContractRequest(contextPath.addSegment("contracts").addKeys(new NameValue(id.toString())));
    }

    public Workbooks workbooks() {
        return new Workbooks(
                        contextPath.addSegment("workbooks"));
    }

    public DriveItemRequest workbooks(String id) {
        return new DriveItemRequest(contextPath.addSegment("workbooks").addKeys(new NameValue(id.toString())));
    }

    public Places places() {
        return new Places(
                        contextPath.addSegment("places"));
    }

    public PlaceRequest places(String id) {
        return new PlaceRequest(contextPath.addSegment("places").addKeys(new NameValue(id.toString())));
    }

    public Drives drives() {
        return new Drives(
                        contextPath.addSegment("drives"));
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id.toString())));
    }

    public Shares shares() {
        return new Shares(
                        contextPath.addSegment("shares"));
    }

    public SharedDriveItemRequest shares(String id) {
        return new SharedDriveItemRequest(contextPath.addSegment("shares").addKeys(new NameValue(id.toString())));
    }

    public Sites sites() {
        return new Sites(
                        contextPath.addSegment("sites"));
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id.toString())));
    }

    public SchemaExtensions schemaExtensions() {
        return new SchemaExtensions(
                        contextPath.addSegment("schemaExtensions"));
    }

    public SchemaExtensionRequest schemaExtensions(String id) {
        return new SchemaExtensionRequest(contextPath.addSegment("schemaExtensions").addKeys(new NameValue(id.toString())));
    }

    public OnPremisesPublishingProfiles onPremisesPublishingProfiles() {
        return new OnPremisesPublishingProfiles(
                        contextPath.addSegment("onPremisesPublishingProfiles"));
    }

    public OnPremisesPublishingProfileRequest onPremisesPublishingProfiles(String id) {
        return new OnPremisesPublishingProfileRequest(contextPath.addSegment("onPremisesPublishingProfiles").addKeys(new NameValue(id.toString())));
    }

    public Connectors connectors() {
        return new Connectors(
                        contextPath.addSegment("connectors"));
    }

    public ConnectorRequest connectors(String id) {
        return new ConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id.toString())));
    }

    public ConnectorGroups connectorGroups() {
        return new ConnectorGroups(
                        contextPath.addSegment("connectorGroups"));
    }

    public ConnectorGroupRequest connectorGroups(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("connectorGroups").addKeys(new NameValue(id.toString())));
    }

    public GroupLifecyclePolicies groupLifecyclePolicies() {
        return new GroupLifecyclePolicies(
                        contextPath.addSegment("groupLifecyclePolicies"));
    }

    public GroupLifecyclePolicyRequest groupLifecyclePolicies(String id) {
        return new GroupLifecyclePolicyRequest(contextPath.addSegment("groupLifecyclePolicies").addKeys(new NameValue(id.toString())));
    }

    public Functions functions() {
        return new Functions(
                        contextPath.addSegment("functions"));
    }

    public AttributeMappingFunctionSchemaRequest functions(String id) {
        return new AttributeMappingFunctionSchemaRequest(contextPath.addSegment("functions").addKeys(new NameValue(id.toString())));
    }

    public FilterOperators filterOperators() {
        return new FilterOperators(
                        contextPath.addSegment("filterOperators"));
    }

    public FilterOperatorSchemaRequest filterOperators(String id) {
        return new FilterOperatorSchemaRequest(contextPath.addSegment("filterOperators").addKeys(new NameValue(id.toString())));
    }

    public AccessReviews accessReviews() {
        return new AccessReviews(
                        contextPath.addSegment("accessReviews"));
    }

    public AccessReviewRequest accessReviews(String id) {
        return new AccessReviewRequest(contextPath.addSegment("accessReviews").addKeys(new NameValue(id.toString())));
    }

    public BusinessFlowTemplates businessFlowTemplates() {
        return new BusinessFlowTemplates(
                        contextPath.addSegment("businessFlowTemplates"));
    }

    public BusinessFlowTemplateRequest businessFlowTemplates(String id) {
        return new BusinessFlowTemplateRequest(contextPath.addSegment("businessFlowTemplates").addKeys(new NameValue(id.toString())));
    }

    public AccessReviewDecisions accessReviewDecisions() {
        return new AccessReviewDecisions(
                        contextPath.addSegment("accessReviewDecisions"));
    }

    public AccessReviewDecisionRequest accessReviewDecisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("accessReviewDecisions").addKeys(new NameValue(id.toString())));
    }

    public Programs programs() {
        return new Programs(
                        contextPath.addSegment("programs"));
    }

    public ProgramRequest programs(String id) {
        return new ProgramRequest(contextPath.addSegment("programs").addKeys(new NameValue(id.toString())));
    }

    public ProgramControls programControls() {
        return new ProgramControls(
                        contextPath.addSegment("programControls"));
    }

    public ProgramControlRequest programControls(String id) {
        return new ProgramControlRequest(contextPath.addSegment("programControls").addKeys(new NameValue(id.toString())));
    }

    public ProgramControlTypes programControlTypes() {
        return new ProgramControlTypes(
                        contextPath.addSegment("programControlTypes"));
    }

    public ProgramControlTypeRequest programControlTypes(String id) {
        return new ProgramControlTypeRequest(contextPath.addSegment("programControlTypes").addKeys(new NameValue(id.toString())));
    }

    public ApprovalWorkflowProviders approvalWorkflowProviders() {
        return new ApprovalWorkflowProviders(
                        contextPath.addSegment("approvalWorkflowProviders"));
    }

    public ApprovalWorkflowProviderRequest approvalWorkflowProviders(String id) {
        return new ApprovalWorkflowProviderRequest(contextPath.addSegment("approvalWorkflowProviders").addKeys(new NameValue(id.toString())));
    }

    public Agreements agreements() {
        return new Agreements(
                        contextPath.addSegment("agreements"));
    }

    public AgreementRequest agreements(String id) {
        return new AgreementRequest(contextPath.addSegment("agreements").addKeys(new NameValue(id.toString())));
    }

    public AgreementAcceptances agreementAcceptances() {
        return new AgreementAcceptances(
                        contextPath.addSegment("agreementAcceptances"));
    }

    public AgreementAcceptanceRequest agreementAcceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("agreementAcceptances").addKeys(new NameValue(id.toString())));
    }

    public RiskDetections riskDetections() {
        return new RiskDetections(
                        contextPath.addSegment("riskDetections"));
    }

    public RiskDetectionRequest riskDetections(String id) {
        return new RiskDetectionRequest(contextPath.addSegment("riskDetections").addKeys(new NameValue(id.toString())));
    }

    public RiskyUsers riskyUsers() {
        return new RiskyUsers(
                        contextPath.addSegment("riskyUsers"));
    }

    public RiskyUserRequest riskyUsers(String id) {
        return new RiskyUserRequest(contextPath.addSegment("riskyUsers").addKeys(new NameValue(id.toString())));
    }

    public PrivilegedAccess privilegedAccess() {
        return new PrivilegedAccess(
                        contextPath.addSegment("privilegedAccess"));
    }

    public PrivilegedAccessRequest privilegedAccess(String id) {
        return new PrivilegedAccessRequest(contextPath.addSegment("privilegedAccess").addKeys(new NameValue(id.toString())));
    }

    public GovernanceResources governanceResources() {
        return new GovernanceResources(
                        contextPath.addSegment("governanceResources"));
    }

    public GovernanceResourceRequest governanceResources(String id) {
        return new GovernanceResourceRequest(contextPath.addSegment("governanceResources").addKeys(new NameValue(id.toString())));
    }

    public GovernanceSubjects governanceSubjects() {
        return new GovernanceSubjects(
                        contextPath.addSegment("governanceSubjects"));
    }

    public GovernanceSubjectRequest governanceSubjects(String id) {
        return new GovernanceSubjectRequest(contextPath.addSegment("governanceSubjects").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleDefinitions governanceRoleDefinitions() {
        return new GovernanceRoleDefinitions(
                        contextPath.addSegment("governanceRoleDefinitions"));
    }

    public GovernanceRoleDefinitionRequest governanceRoleDefinitions(String id) {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("governanceRoleDefinitions").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignments governanceRoleAssignments() {
        return new GovernanceRoleAssignments(
                        contextPath.addSegment("governanceRoleAssignments"));
    }

    public GovernanceRoleAssignmentRequest governanceRoleAssignments(String id) {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("governanceRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignmentRequests governanceRoleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequests(
                        contextPath.addSegment("governanceRoleAssignmentRequests"));
    }

    public GovernanceRoleAssignmentRequestRequest governanceRoleAssignmentRequests(String id) {
        return new GovernanceRoleAssignmentRequestRequest(contextPath.addSegment("governanceRoleAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleSettings governanceRoleSettings() {
        return new GovernanceRoleSettings(
                        contextPath.addSegment("governanceRoleSettings"));
    }

    public GovernanceRoleSettingRequest governanceRoleSettings(String id) {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("governanceRoleSettings").addKeys(new NameValue(id.toString())));
    }

    public PrivilegedRoles privilegedRoles() {
        return new PrivilegedRoles(
                        contextPath.addSegment("privilegedRoles"));
    }

    public PrivilegedRoleRequest privilegedRoles(String id) {
        return new PrivilegedRoleRequest(contextPath.addSegment("privilegedRoles").addKeys(new NameValue(id.toString())));
    }

    public PrivilegedRoleAssignments privilegedRoleAssignments() {
        return new PrivilegedRoleAssignments(
                        contextPath.addSegment("privilegedRoleAssignments"));
    }

    public PrivilegedRoleAssignmentRequest privilegedRoleAssignments(String id) {
        return new PrivilegedRoleAssignmentRequest(contextPath.addSegment("privilegedRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public PrivilegedOperationEvents privilegedOperationEvents() {
        return new PrivilegedOperationEvents(
                        contextPath.addSegment("privilegedOperationEvents"));
    }

    public PrivilegedOperationEventRequest privilegedOperationEvents(String id) {
        return new PrivilegedOperationEventRequest(contextPath.addSegment("privilegedOperationEvents").addKeys(new NameValue(id.toString())));
    }

    public PrivilegedSignupStatus privilegedSignupStatus() {
        return new PrivilegedSignupStatus(
                        contextPath.addSegment("privilegedSignupStatus"));
    }

    public PrivilegedSignupStatusRequest privilegedSignupStatus(String id) {
        return new PrivilegedSignupStatusRequest(contextPath.addSegment("privilegedSignupStatus").addKeys(new NameValue(id.toString())));
    }

    public PrivilegedApproval privilegedApproval() {
        return new PrivilegedApproval(
                        contextPath.addSegment("privilegedApproval"));
    }

    public PrivilegedApprovalRequest privilegedApproval(String id) {
        return new PrivilegedApprovalRequest(contextPath.addSegment("privilegedApproval").addKeys(new NameValue(id.toString())));
    }

    public PrivilegedRoleAssignmentRequests privilegedRoleAssignmentRequests() {
        return new PrivilegedRoleAssignmentRequests(
                        contextPath.addSegment("privilegedRoleAssignmentRequests"));
    }

    public PrivilegedRoleAssignmentRequestRequest privilegedRoleAssignmentRequests(String id) {
        return new PrivilegedRoleAssignmentRequestRequest(contextPath.addSegment("privilegedRoleAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public DataPolicyOperations dataPolicyOperations() {
        return new DataPolicyOperations(
                        contextPath.addSegment("dataPolicyOperations"));
    }

    public DataPolicyOperationRequest dataPolicyOperations(String id) {
        return new DataPolicyOperationRequest(contextPath.addSegment("dataPolicyOperations").addKeys(new NameValue(id.toString())));
    }

    public Commands commands() {
        return new Commands(
                        contextPath.addSegment("commands"));
    }

    public CommandRequest commands(String id) {
        return new CommandRequest(contextPath.addSegment("commands").addKeys(new NameValue(id.toString())));
    }

    public PayloadResponse payloadResponse() {
        return new PayloadResponse(
                        contextPath.addSegment("payloadResponse"));
    }

    public PayloadResponseRequest payloadResponse(String id) {
        return new PayloadResponseRequest(contextPath.addSegment("payloadResponse").addKeys(new NameValue(id.toString())));
    }

    public Subscriptions subscriptions() {
        return new Subscriptions(
                        contextPath.addSegment("subscriptions"));
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id.toString())));
    }

    public Connections connections() {
        return new Connections(
                        contextPath.addSegment("connections"));
    }

    public ExternalConnectionRequest connections(String id) {
        return new ExternalConnectionRequest(contextPath.addSegment("connections").addKeys(new NameValue(id.toString())));
    }

    public Teams teams() {
        return new Teams(
                        contextPath.addSegment("teams"));
    }

    public TeamRequest teams(String id) {
        return new TeamRequest(contextPath.addSegment("teams").addKeys(new NameValue(id.toString())));
    }

    public Chats chats() {
        return new Chats(
                        contextPath.addSegment("chats"));
    }

    public ChatRequest chats(String id) {
        return new ChatRequest(contextPath.addSegment("chats").addKeys(new NameValue(id.toString())));
    }

    public TeamsTemplates teamsTemplates() {
        return new TeamsTemplates(
                        contextPath.addSegment("teamsTemplates"));
    }

    public TeamsTemplateRequest teamsTemplates(String id) {
        return new TeamsTemplateRequest(contextPath.addSegment("teamsTemplates").addKeys(new NameValue(id.toString())));
    }

    public AuditLogRootRequest auditLogs() {
        return new AuditLogRootRequest(contextPath.addSegment("auditLogs"));
    }

    public ReportRootRequest reports() {
        return new ReportRootRequest(contextPath.addSegment("reports"));
    }

    public BitlockerRequest bitlocker() {
        return new BitlockerRequest(contextPath.addSegment("bitlocker"));
    }

    public IdentityContainerRequest identity() {
        return new IdentityContainerRequest(contextPath.addSegment("identity"));
    }

    public TrustFrameworkRequest trustFramework() {
        return new TrustFrameworkRequest(contextPath.addSegment("trustFramework"));
    }

    public ComplianceRequest compliance() {
        return new ComplianceRequest(contextPath.addSegment("compliance"));
    }

    public DataClassificationServiceRequest dataClassification() {
        return new DataClassificationServiceRequest(contextPath.addSegment("dataClassification"));
    }

    public InformationProtectionRequest informationProtection() {
        return new InformationProtectionRequest(contextPath.addSegment("informationProtection"));
    }

    public PolicyRootRequest policies() {
        return new PolicyRootRequest(contextPath.addSegment("policies"));
    }

    public UserRequest me() {
        return new UserRequest(contextPath.addSegment("me"));
    }

    public RoleManagementRequest roleManagement() {
        return new RoleManagementRequest(contextPath.addSegment("roleManagement"));
    }

    public DirectoryRequest directory() {
        return new DirectoryRequest(contextPath.addSegment("directory"));
    }

    public EducationRootRequest education() {
        return new EducationRootRequest(contextPath.addSegment("education"));
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"));
    }

    public CloudCommunicationsRequest communications() {
        return new CloudCommunicationsRequest(contextPath.addSegment("communications"));
    }

    public IdentityGovernanceRequest identityGovernance() {
        return new IdentityGovernanceRequest(contextPath.addSegment("identityGovernance"));
    }

    public ConditionalAccessRootRequest conditionalAccess() {
        return new ConditionalAccessRootRequest(contextPath.addSegment("conditionalAccess"));
    }

    public IdentityProtectionRootRequest identityProtection() {
        return new IdentityProtectionRootRequest(contextPath.addSegment("identityProtection"));
    }

    public DeviceManagementRequest deviceManagement() {
        return new DeviceManagementRequest(contextPath.addSegment("deviceManagement"));
    }

    public DeviceAppManagementRequest deviceAppManagement() {
        return new DeviceAppManagementRequest(contextPath.addSegment("deviceAppManagement"));
    }

    public OfficeConfigurationRequest officeConfiguration() {
        return new OfficeConfigurationRequest(contextPath.addSegment("officeConfiguration"));
    }

    public SearchRequest search() {
        return new SearchRequest(contextPath.addSegment("search"));
    }

    public FinancialsRequest financials() {
        return new FinancialsRequest(contextPath.addSegment("financials"));
    }

    public PlannerRequest planner() {
        return new PlannerRequest(contextPath.addSegment("planner"));
    }

    public PrintRequest print() {
        return new PrintRequest(contextPath.addSegment("print"));
    }

    public SecurityRequest security() {
        return new SecurityRequest(contextPath.addSegment("Security"));
    }

    public CommsApplicationRequest app() {
        return new CommsApplicationRequest(contextPath.addSegment("app"));
    }

    public ExternalRequest external() {
        return new ExternalRequest(contextPath.addSegment("external"));
    }

    public TeamworkRequest teamwork() {
        return new TeamworkRequest(contextPath.addSegment("teamwork"));
    }

    public AppCatalogsRequest appCatalogs() {
        return new AppCatalogsRequest(contextPath.addSegment("appCatalogs"));
    }

}
