package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.WorkforceIntegrationEncryptionProtocol;

@JsonPropertyOrder({
    "@odata.type", 
    "protocol", 
    "secret"})
@JsonInclude(Include.NON_NULL)
public class WorkforceIntegrationEncryption implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("protocol")
    protected WorkforceIntegrationEncryptionProtocol protocol;

    @JsonProperty("secret")
    protected String secret;

    protected WorkforceIntegrationEncryption() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workforceIntegrationEncryption";
    }

    @Property(name="protocol")
    @JsonIgnore
    public Optional<WorkforceIntegrationEncryptionProtocol> getProtocol() {
        return Optional.ofNullable(protocol);
    }

    public WorkforceIntegrationEncryption withProtocol(WorkforceIntegrationEncryptionProtocol protocol) {
        WorkforceIntegrationEncryption _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegrationEncryption");
        _x.protocol = protocol;
        return _x;
    }

    @Property(name="secret")
    @JsonIgnore
    public Optional<String> getSecret() {
        return Optional.ofNullable(secret);
    }

    public WorkforceIntegrationEncryption withSecret(String secret) {
        WorkforceIntegrationEncryption _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workforceIntegrationEncryption");
        _x.secret = secret;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private WorkforceIntegrationEncryptionProtocol protocol;
        private String secret;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder protocol(WorkforceIntegrationEncryptionProtocol protocol) {
            this.protocol = protocol;
            this.changedFields = changedFields.add("protocol");
            return this;
        }

        public Builder secret(String secret) {
            this.secret = secret;
            this.changedFields = changedFields.add("secret");
            return this;
        }

        public WorkforceIntegrationEncryption build() {
            WorkforceIntegrationEncryption _x = new WorkforceIntegrationEncryption();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workforceIntegrationEncryption";
            _x.protocol = protocol;
            _x.secret = secret;
            return _x;
        }
    }

    private WorkforceIntegrationEncryption _copy() {
        WorkforceIntegrationEncryption _x = new WorkforceIntegrationEncryption();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.protocol = protocol;
        _x.secret = secret;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkforceIntegrationEncryption[");
        b.append("protocol=");
        b.append(this.protocol);
        b.append(", ");
        b.append("secret=");
        b.append(this.secret);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
