package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowAutoFilter", 
    "allowDeleteColumns", 
    "allowDeleteRows", 
    "allowFormatCells", 
    "allowFormatColumns", 
    "allowFormatRows", 
    "allowInsertColumns", 
    "allowInsertHyperlinks", 
    "allowInsertRows", 
    "allowPivotTables", 
    "allowSort"})
@JsonInclude(Include.NON_NULL)
public class WorkbookWorksheetProtectionOptions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowAutoFilter")
    protected Boolean allowAutoFilter;

    @JsonProperty("allowDeleteColumns")
    protected Boolean allowDeleteColumns;

    @JsonProperty("allowDeleteRows")
    protected Boolean allowDeleteRows;

    @JsonProperty("allowFormatCells")
    protected Boolean allowFormatCells;

    @JsonProperty("allowFormatColumns")
    protected Boolean allowFormatColumns;

    @JsonProperty("allowFormatRows")
    protected Boolean allowFormatRows;

    @JsonProperty("allowInsertColumns")
    protected Boolean allowInsertColumns;

    @JsonProperty("allowInsertHyperlinks")
    protected Boolean allowInsertHyperlinks;

    @JsonProperty("allowInsertRows")
    protected Boolean allowInsertRows;

    @JsonProperty("allowPivotTables")
    protected Boolean allowPivotTables;

    @JsonProperty("allowSort")
    protected Boolean allowSort;

    protected WorkbookWorksheetProtectionOptions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookWorksheetProtectionOptions";
    }

    @Property(name="allowAutoFilter")
    @JsonIgnore
    public Optional<Boolean> getAllowAutoFilter() {
        return Optional.ofNullable(allowAutoFilter);
    }

    public WorkbookWorksheetProtectionOptions withAllowAutoFilter(Boolean allowAutoFilter) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowAutoFilter = allowAutoFilter;
        return _x;
    }

    @Property(name="allowDeleteColumns")
    @JsonIgnore
    public Optional<Boolean> getAllowDeleteColumns() {
        return Optional.ofNullable(allowDeleteColumns);
    }

    public WorkbookWorksheetProtectionOptions withAllowDeleteColumns(Boolean allowDeleteColumns) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowDeleteColumns = allowDeleteColumns;
        return _x;
    }

    @Property(name="allowDeleteRows")
    @JsonIgnore
    public Optional<Boolean> getAllowDeleteRows() {
        return Optional.ofNullable(allowDeleteRows);
    }

    public WorkbookWorksheetProtectionOptions withAllowDeleteRows(Boolean allowDeleteRows) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowDeleteRows = allowDeleteRows;
        return _x;
    }

    @Property(name="allowFormatCells")
    @JsonIgnore
    public Optional<Boolean> getAllowFormatCells() {
        return Optional.ofNullable(allowFormatCells);
    }

    public WorkbookWorksheetProtectionOptions withAllowFormatCells(Boolean allowFormatCells) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowFormatCells = allowFormatCells;
        return _x;
    }

    @Property(name="allowFormatColumns")
    @JsonIgnore
    public Optional<Boolean> getAllowFormatColumns() {
        return Optional.ofNullable(allowFormatColumns);
    }

    public WorkbookWorksheetProtectionOptions withAllowFormatColumns(Boolean allowFormatColumns) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowFormatColumns = allowFormatColumns;
        return _x;
    }

    @Property(name="allowFormatRows")
    @JsonIgnore
    public Optional<Boolean> getAllowFormatRows() {
        return Optional.ofNullable(allowFormatRows);
    }

    public WorkbookWorksheetProtectionOptions withAllowFormatRows(Boolean allowFormatRows) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowFormatRows = allowFormatRows;
        return _x;
    }

    @Property(name="allowInsertColumns")
    @JsonIgnore
    public Optional<Boolean> getAllowInsertColumns() {
        return Optional.ofNullable(allowInsertColumns);
    }

    public WorkbookWorksheetProtectionOptions withAllowInsertColumns(Boolean allowInsertColumns) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowInsertColumns = allowInsertColumns;
        return _x;
    }

    @Property(name="allowInsertHyperlinks")
    @JsonIgnore
    public Optional<Boolean> getAllowInsertHyperlinks() {
        return Optional.ofNullable(allowInsertHyperlinks);
    }

    public WorkbookWorksheetProtectionOptions withAllowInsertHyperlinks(Boolean allowInsertHyperlinks) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowInsertHyperlinks = allowInsertHyperlinks;
        return _x;
    }

    @Property(name="allowInsertRows")
    @JsonIgnore
    public Optional<Boolean> getAllowInsertRows() {
        return Optional.ofNullable(allowInsertRows);
    }

    public WorkbookWorksheetProtectionOptions withAllowInsertRows(Boolean allowInsertRows) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowInsertRows = allowInsertRows;
        return _x;
    }

    @Property(name="allowPivotTables")
    @JsonIgnore
    public Optional<Boolean> getAllowPivotTables() {
        return Optional.ofNullable(allowPivotTables);
    }

    public WorkbookWorksheetProtectionOptions withAllowPivotTables(Boolean allowPivotTables) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowPivotTables = allowPivotTables;
        return _x;
    }

    @Property(name="allowSort")
    @JsonIgnore
    public Optional<Boolean> getAllowSort() {
        return Optional.ofNullable(allowSort);
    }

    public WorkbookWorksheetProtectionOptions withAllowSort(Boolean allowSort) {
        WorkbookWorksheetProtectionOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookWorksheetProtectionOptions");
        _x.allowSort = allowSort;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowAutoFilter;
        private Boolean allowDeleteColumns;
        private Boolean allowDeleteRows;
        private Boolean allowFormatCells;
        private Boolean allowFormatColumns;
        private Boolean allowFormatRows;
        private Boolean allowInsertColumns;
        private Boolean allowInsertHyperlinks;
        private Boolean allowInsertRows;
        private Boolean allowPivotTables;
        private Boolean allowSort;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowAutoFilter(Boolean allowAutoFilter) {
            this.allowAutoFilter = allowAutoFilter;
            this.changedFields = changedFields.add("allowAutoFilter");
            return this;
        }

        public Builder allowDeleteColumns(Boolean allowDeleteColumns) {
            this.allowDeleteColumns = allowDeleteColumns;
            this.changedFields = changedFields.add("allowDeleteColumns");
            return this;
        }

        public Builder allowDeleteRows(Boolean allowDeleteRows) {
            this.allowDeleteRows = allowDeleteRows;
            this.changedFields = changedFields.add("allowDeleteRows");
            return this;
        }

        public Builder allowFormatCells(Boolean allowFormatCells) {
            this.allowFormatCells = allowFormatCells;
            this.changedFields = changedFields.add("allowFormatCells");
            return this;
        }

        public Builder allowFormatColumns(Boolean allowFormatColumns) {
            this.allowFormatColumns = allowFormatColumns;
            this.changedFields = changedFields.add("allowFormatColumns");
            return this;
        }

        public Builder allowFormatRows(Boolean allowFormatRows) {
            this.allowFormatRows = allowFormatRows;
            this.changedFields = changedFields.add("allowFormatRows");
            return this;
        }

        public Builder allowInsertColumns(Boolean allowInsertColumns) {
            this.allowInsertColumns = allowInsertColumns;
            this.changedFields = changedFields.add("allowInsertColumns");
            return this;
        }

        public Builder allowInsertHyperlinks(Boolean allowInsertHyperlinks) {
            this.allowInsertHyperlinks = allowInsertHyperlinks;
            this.changedFields = changedFields.add("allowInsertHyperlinks");
            return this;
        }

        public Builder allowInsertRows(Boolean allowInsertRows) {
            this.allowInsertRows = allowInsertRows;
            this.changedFields = changedFields.add("allowInsertRows");
            return this;
        }

        public Builder allowPivotTables(Boolean allowPivotTables) {
            this.allowPivotTables = allowPivotTables;
            this.changedFields = changedFields.add("allowPivotTables");
            return this;
        }

        public Builder allowSort(Boolean allowSort) {
            this.allowSort = allowSort;
            this.changedFields = changedFields.add("allowSort");
            return this;
        }

        public WorkbookWorksheetProtectionOptions build() {
            WorkbookWorksheetProtectionOptions _x = new WorkbookWorksheetProtectionOptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookWorksheetProtectionOptions";
            _x.allowAutoFilter = allowAutoFilter;
            _x.allowDeleteColumns = allowDeleteColumns;
            _x.allowDeleteRows = allowDeleteRows;
            _x.allowFormatCells = allowFormatCells;
            _x.allowFormatColumns = allowFormatColumns;
            _x.allowFormatRows = allowFormatRows;
            _x.allowInsertColumns = allowInsertColumns;
            _x.allowInsertHyperlinks = allowInsertHyperlinks;
            _x.allowInsertRows = allowInsertRows;
            _x.allowPivotTables = allowPivotTables;
            _x.allowSort = allowSort;
            return _x;
        }
    }

    private WorkbookWorksheetProtectionOptions _copy() {
        WorkbookWorksheetProtectionOptions _x = new WorkbookWorksheetProtectionOptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowAutoFilter = allowAutoFilter;
        _x.allowDeleteColumns = allowDeleteColumns;
        _x.allowDeleteRows = allowDeleteRows;
        _x.allowFormatCells = allowFormatCells;
        _x.allowFormatColumns = allowFormatColumns;
        _x.allowFormatRows = allowFormatRows;
        _x.allowInsertColumns = allowInsertColumns;
        _x.allowInsertHyperlinks = allowInsertHyperlinks;
        _x.allowInsertRows = allowInsertRows;
        _x.allowPivotTables = allowPivotTables;
        _x.allowSort = allowSort;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookWorksheetProtectionOptions[");
        b.append("allowAutoFilter=");
        b.append(this.allowAutoFilter);
        b.append(", ");
        b.append("allowDeleteColumns=");
        b.append(this.allowDeleteColumns);
        b.append(", ");
        b.append("allowDeleteRows=");
        b.append(this.allowDeleteRows);
        b.append(", ");
        b.append("allowFormatCells=");
        b.append(this.allowFormatCells);
        b.append(", ");
        b.append("allowFormatColumns=");
        b.append(this.allowFormatColumns);
        b.append(", ");
        b.append("allowFormatRows=");
        b.append(this.allowFormatRows);
        b.append(", ");
        b.append("allowInsertColumns=");
        b.append(this.allowInsertColumns);
        b.append(", ");
        b.append("allowInsertHyperlinks=");
        b.append(this.allowInsertHyperlinks);
        b.append(", ");
        b.append("allowInsertRows=");
        b.append(this.allowInsertRows);
        b.append(", ");
        b.append("allowPivotTables=");
        b.append(this.allowPivotTables);
        b.append(", ");
        b.append("allowSort=");
        b.append(this.allowSort);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
