package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "message", 
    "innerError"})
@JsonInclude(Include.NON_NULL)
public class WorkbookOperationError implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("code")
    protected String code;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("innerError")
    protected WorkbookOperationError innerError;

    protected WorkbookOperationError() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookOperationError";
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public WorkbookOperationError withCode(String code) {
        WorkbookOperationError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookOperationError");
        _x.code = code;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public WorkbookOperationError withMessage(String message) {
        WorkbookOperationError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookOperationError");
        _x.message = message;
        return _x;
    }

    @Property(name="innerError")
    @JsonIgnore
    public Optional<WorkbookOperationError> getInnerError() {
        return Optional.ofNullable(innerError);
    }

    public WorkbookOperationError withInnerError(WorkbookOperationError innerError) {
        WorkbookOperationError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookOperationError");
        _x.innerError = innerError;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String code;
        private String message;
        private WorkbookOperationError innerError;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder innerError(WorkbookOperationError innerError) {
            this.innerError = innerError;
            this.changedFields = changedFields.add("innerError");
            return this;
        }

        public WorkbookOperationError build() {
            WorkbookOperationError _x = new WorkbookOperationError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookOperationError";
            _x.code = code;
            _x.message = message;
            _x.innerError = innerError;
            return _x;
        }
    }

    private WorkbookOperationError _copy() {
        WorkbookOperationError _x = new WorkbookOperationError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.code = code;
        _x.message = message;
        _x.innerError = innerError;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookOperationError[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("innerError=");
        b.append(this.innerError);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
