package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "date", 
    "specificity"})
@JsonInclude(Include.NON_NULL)
public class WorkbookFilterDatetime implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("date")
    protected String date;

    @JsonProperty("specificity")
    protected String specificity;

    protected WorkbookFilterDatetime() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookFilterDatetime";
    }

    @Property(name="date")
    @JsonIgnore
    public Optional<String> getDate() {
        return Optional.ofNullable(date);
    }

    public WorkbookFilterDatetime withDate(String date) {
        WorkbookFilterDatetime _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterDatetime");
        _x.date = date;
        return _x;
    }

    @Property(name="specificity")
    @JsonIgnore
    public Optional<String> getSpecificity() {
        return Optional.ofNullable(specificity);
    }

    public WorkbookFilterDatetime withSpecificity(String specificity) {
        WorkbookFilterDatetime _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterDatetime");
        _x.specificity = specificity;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String date;
        private String specificity;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder date(String date) {
            this.date = date;
            this.changedFields = changedFields.add("date");
            return this;
        }

        public Builder specificity(String specificity) {
            this.specificity = specificity;
            this.changedFields = changedFields.add("specificity");
            return this;
        }

        public WorkbookFilterDatetime build() {
            WorkbookFilterDatetime _x = new WorkbookFilterDatetime();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookFilterDatetime";
            _x.date = date;
            _x.specificity = specificity;
            return _x;
        }
    }

    private WorkbookFilterDatetime _copy() {
        WorkbookFilterDatetime _x = new WorkbookFilterDatetime();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.date = date;
        _x.specificity = specificity;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookFilterDatetime[");
        b.append("date=");
        b.append(this.date);
        b.append(", ");
        b.append("specificity=");
        b.append(this.specificity);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
