package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "color", 
    "criterion1", 
    "criterion2", 
    "dynamicCriteria", 
    "filterOn", 
    "icon", 
    "operator", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class WorkbookFilterCriteria implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("color")
    protected String color;

    @JsonProperty("criterion1")
    protected String criterion1;

    @JsonProperty("criterion2")
    protected String criterion2;

    @JsonProperty("dynamicCriteria")
    protected String dynamicCriteria;

    @JsonProperty("filterOn")
    protected String filterOn;

    @JsonProperty("icon")
    protected WorkbookIcon icon;

    @JsonProperty("operator")
    protected String operator;

    @JsonProperty("values")
    protected Json values;

    protected WorkbookFilterCriteria() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookFilterCriteria";
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public WorkbookFilterCriteria withColor(String color) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.color = color;
        return _x;
    }

    @Property(name="criterion1")
    @JsonIgnore
    public Optional<String> getCriterion1() {
        return Optional.ofNullable(criterion1);
    }

    public WorkbookFilterCriteria withCriterion1(String criterion1) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.criterion1 = criterion1;
        return _x;
    }

    @Property(name="criterion2")
    @JsonIgnore
    public Optional<String> getCriterion2() {
        return Optional.ofNullable(criterion2);
    }

    public WorkbookFilterCriteria withCriterion2(String criterion2) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.criterion2 = criterion2;
        return _x;
    }

    @Property(name="dynamicCriteria")
    @JsonIgnore
    public Optional<String> getDynamicCriteria() {
        return Optional.ofNullable(dynamicCriteria);
    }

    public WorkbookFilterCriteria withDynamicCriteria(String dynamicCriteria) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.dynamicCriteria = dynamicCriteria;
        return _x;
    }

    @Property(name="filterOn")
    @JsonIgnore
    public Optional<String> getFilterOn() {
        return Optional.ofNullable(filterOn);
    }

    public WorkbookFilterCriteria withFilterOn(String filterOn) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.filterOn = filterOn;
        return _x;
    }

    @Property(name="icon")
    @JsonIgnore
    public Optional<WorkbookIcon> getIcon() {
        return Optional.ofNullable(icon);
    }

    public WorkbookFilterCriteria withIcon(WorkbookIcon icon) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.icon = icon;
        return _x;
    }

    @Property(name="operator")
    @JsonIgnore
    public Optional<String> getOperator() {
        return Optional.ofNullable(operator);
    }

    public WorkbookFilterCriteria withOperator(String operator) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.operator = operator;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public Optional<Json> getValues() {
        return Optional.ofNullable(values);
    }

    public WorkbookFilterCriteria withValues(Json values) {
        WorkbookFilterCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFilterCriteria");
        _x.values = values;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String color;
        private String criterion1;
        private String criterion2;
        private String dynamicCriteria;
        private String filterOn;
        private WorkbookIcon icon;
        private String operator;
        private Json values;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder criterion1(String criterion1) {
            this.criterion1 = criterion1;
            this.changedFields = changedFields.add("criterion1");
            return this;
        }

        public Builder criterion2(String criterion2) {
            this.criterion2 = criterion2;
            this.changedFields = changedFields.add("criterion2");
            return this;
        }

        public Builder dynamicCriteria(String dynamicCriteria) {
            this.dynamicCriteria = dynamicCriteria;
            this.changedFields = changedFields.add("dynamicCriteria");
            return this;
        }

        public Builder filterOn(String filterOn) {
            this.filterOn = filterOn;
            this.changedFields = changedFields.add("filterOn");
            return this;
        }

        public Builder icon(WorkbookIcon icon) {
            this.icon = icon;
            this.changedFields = changedFields.add("icon");
            return this;
        }

        public Builder operator(String operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        public Builder values(Json values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public WorkbookFilterCriteria build() {
            WorkbookFilterCriteria _x = new WorkbookFilterCriteria();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.workbookFilterCriteria";
            _x.color = color;
            _x.criterion1 = criterion1;
            _x.criterion2 = criterion2;
            _x.dynamicCriteria = dynamicCriteria;
            _x.filterOn = filterOn;
            _x.icon = icon;
            _x.operator = operator;
            _x.values = values;
            return _x;
        }
    }

    private WorkbookFilterCriteria _copy() {
        WorkbookFilterCriteria _x = new WorkbookFilterCriteria();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.color = color;
        _x.criterion1 = criterion1;
        _x.criterion2 = criterion2;
        _x.dynamicCriteria = dynamicCriteria;
        _x.filterOn = filterOn;
        _x.icon = icon;
        _x.operator = operator;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookFilterCriteria[");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("criterion1=");
        b.append(this.criterion1);
        b.append(", ");
        b.append("criterion2=");
        b.append(this.criterion2);
        b.append(", ");
        b.append("dynamicCriteria=");
        b.append(this.dynamicCriteria);
        b.append(", ");
        b.append("filterOn=");
        b.append(this.filterOn);
        b.append(", ");
        b.append("icon=");
        b.append(this.icon);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
