package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WeeklySchedule;

@JsonPropertyOrder({
    "@odata.type", 
    "scheduledInstallDay", 
    "scheduledInstallTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsUpdateScheduledInstall extends WindowsUpdateInstallScheduleType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("scheduledInstallDay")
    protected WeeklySchedule scheduledInstallDay;

    @JsonProperty("scheduledInstallTime")
    protected LocalTime scheduledInstallTime;

    protected WindowsUpdateScheduledInstall() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdateScheduledInstall";
    }

    /**
     * <i>“Scheduled Install Day in week”</i>
     * 
     * @return property scheduledInstallDay
     */
    @Property(name="scheduledInstallDay")
    @JsonIgnore
    public Optional<WeeklySchedule> getScheduledInstallDay() {
        return Optional.ofNullable(scheduledInstallDay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * scheduledInstallDay} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Scheduled Install Day in week”</i>
     * 
     * @param scheduledInstallDay
     *            new value of {@code scheduledInstallDay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scheduledInstallDay} field changed
     */
    public WindowsUpdateScheduledInstall withScheduledInstallDay(WeeklySchedule scheduledInstallDay) {
        WindowsUpdateScheduledInstall _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateScheduledInstall");
        _x.scheduledInstallDay = scheduledInstallDay;
        return _x;
    }

    /**
     * <i>“Scheduled Install Time during day”</i>
     * 
     * @return property scheduledInstallTime
     */
    @Property(name="scheduledInstallTime")
    @JsonIgnore
    public Optional<LocalTime> getScheduledInstallTime() {
        return Optional.ofNullable(scheduledInstallTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * scheduledInstallTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Scheduled Install Time during day”</i>
     * 
     * @param scheduledInstallTime
     *            new value of {@code scheduledInstallTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scheduledInstallTime} field changed
     */
    public WindowsUpdateScheduledInstall withScheduledInstallTime(LocalTime scheduledInstallTime) {
        WindowsUpdateScheduledInstall _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdateScheduledInstall");
        _x.scheduledInstallTime = scheduledInstallTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsUpdateScheduledInstall() {
        return new Builder();
    }

    public static final class Builder {
        private WeeklySchedule scheduledInstallDay;
        private LocalTime scheduledInstallTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Scheduled Install Day in week”</i>
         * 
         * @param scheduledInstallDay
         *            value of {@code scheduledInstallDay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledInstallDay(WeeklySchedule scheduledInstallDay) {
            this.scheduledInstallDay = scheduledInstallDay;
            this.changedFields = changedFields.add("scheduledInstallDay");
            return this;
        }

        /**
         * <i>“Scheduled Install Time during day”</i>
         * 
         * @param scheduledInstallTime
         *            value of {@code scheduledInstallTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scheduledInstallTime(LocalTime scheduledInstallTime) {
            this.scheduledInstallTime = scheduledInstallTime;
            this.changedFields = changedFields.add("scheduledInstallTime");
            return this;
        }

        public WindowsUpdateScheduledInstall build() {
            WindowsUpdateScheduledInstall _x = new WindowsUpdateScheduledInstall();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsUpdateScheduledInstall";
            _x.scheduledInstallDay = scheduledInstallDay;
            _x.scheduledInstallTime = scheduledInstallTime;
            return _x;
        }
    }

    private WindowsUpdateScheduledInstall _copy() {
        WindowsUpdateScheduledInstall _x = new WindowsUpdateScheduledInstall();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.scheduledInstallDay = scheduledInstallDay;
        _x.scheduledInstallTime = scheduledInstallTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUpdateScheduledInstall[");
        b.append("scheduledInstallDay=");
        b.append(this.scheduledInstallDay);
        b.append(", ");
        b.append("scheduledInstallTime=");
        b.append(this.scheduledInstallTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
