package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Contains properties used when assigning a Windows Universal AppX mobile app to a
 * group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "useDeviceContext"})
@JsonInclude(Include.NON_NULL)
public class WindowsUniversalAppXAppAssignmentSettings extends MobileAppAssignmentSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("useDeviceContext")
    protected Boolean useDeviceContext;

    protected WindowsUniversalAppXAppAssignmentSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUniversalAppXAppAssignmentSettings";
    }

    /**
     * <i>“Whether or not to use device execution context for Windows Universal AppX mobile
     * app.”</i>
     * 
     * @return property useDeviceContext
     */
    @Property(name="useDeviceContext")
    @JsonIgnore
    public Optional<Boolean> getUseDeviceContext() {
        return Optional.ofNullable(useDeviceContext);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code useDeviceContext}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to use device execution context for Windows Universal AppX mobile
     * app.”</i>
     * 
     * @param useDeviceContext
     *            new value of {@code useDeviceContext} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useDeviceContext} field changed
     */
    public WindowsUniversalAppXAppAssignmentSettings withUseDeviceContext(Boolean useDeviceContext) {
        WindowsUniversalAppXAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUniversalAppXAppAssignmentSettings");
        _x.useDeviceContext = useDeviceContext;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsUniversalAppXAppAssignmentSettings() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean useDeviceContext;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether or not to use device execution context for Windows Universal AppX mobile
         * app.”</i>
         * 
         * @param useDeviceContext
         *            value of {@code useDeviceContext} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useDeviceContext(Boolean useDeviceContext) {
            this.useDeviceContext = useDeviceContext;
            this.changedFields = changedFields.add("useDeviceContext");
            return this;
        }

        public WindowsUniversalAppXAppAssignmentSettings build() {
            WindowsUniversalAppXAppAssignmentSettings _x = new WindowsUniversalAppXAppAssignmentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsUniversalAppXAppAssignmentSettings";
            _x.useDeviceContext = useDeviceContext;
            return _x;
        }
    }

    private WindowsUniversalAppXAppAssignmentSettings _copy() {
        WindowsUniversalAppXAppAssignmentSettings _x = new WindowsUniversalAppXAppAssignmentSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.useDeviceContext = useDeviceContext;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsUniversalAppXAppAssignmentSettings[");
        b.append("useDeviceContext=");
        b.append(this.useDeviceContext);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
