package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Windows Network Isolation Policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enterpriseNetworkDomainNames", 
    "enterpriseCloudResources", 
    "enterpriseIPRanges", 
    "enterpriseInternalProxyServers", 
    "enterpriseIPRangesAreAuthoritative", 
    "enterpriseProxyServers", 
    "enterpriseProxyServersAreAuthoritative", 
    "neutralDomainResources"})
@JsonInclude(Include.NON_NULL)
public class WindowsNetworkIsolationPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enterpriseNetworkDomainNames")
    protected List<String> enterpriseNetworkDomainNames;

    @JsonProperty("enterpriseNetworkDomainNames@nextLink")
    protected String enterpriseNetworkDomainNamesNextLink;

    @JsonProperty("enterpriseCloudResources")
    protected List<ProxiedDomain> enterpriseCloudResources;

    @JsonProperty("enterpriseCloudResources@nextLink")
    protected String enterpriseCloudResourcesNextLink;

    @JsonProperty("enterpriseIPRanges")
    protected List<IpRange> enterpriseIPRanges;

    @JsonProperty("enterpriseIPRanges@nextLink")
    protected String enterpriseIPRangesNextLink;

    @JsonProperty("enterpriseInternalProxyServers")
    protected List<String> enterpriseInternalProxyServers;

    @JsonProperty("enterpriseInternalProxyServers@nextLink")
    protected String enterpriseInternalProxyServersNextLink;

    @JsonProperty("enterpriseIPRangesAreAuthoritative")
    protected Boolean enterpriseIPRangesAreAuthoritative;

    @JsonProperty("enterpriseProxyServers")
    protected List<String> enterpriseProxyServers;

    @JsonProperty("enterpriseProxyServers@nextLink")
    protected String enterpriseProxyServersNextLink;

    @JsonProperty("enterpriseProxyServersAreAuthoritative")
    protected Boolean enterpriseProxyServersAreAuthoritative;

    @JsonProperty("neutralDomainResources")
    protected List<String> neutralDomainResources;

    @JsonProperty("neutralDomainResources@nextLink")
    protected String neutralDomainResourcesNextLink;

    protected WindowsNetworkIsolationPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsNetworkIsolationPolicy";
    }

    /**
     * <i>“This is the list of domains that comprise the boundaries of the enterprise. Data
     * from one of these domains that is sent to a device will be considered enterprise
     * data and protected. These locations will be considered a safe destination for
     * enterprise data to be shared to.”</i>
     * 
     * @return property enterpriseNetworkDomainNames
     */
    @Property(name="enterpriseNetworkDomainNames")
    @JsonIgnore
    public CollectionPage<String> getEnterpriseNetworkDomainNames() {
        return new CollectionPage<String>(contextPath, String.class, enterpriseNetworkDomainNames, Optional.ofNullable(enterpriseNetworkDomainNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“This is the list of domains that comprise the boundaries of the enterprise. Data
     * from one of these domains that is sent to a device will be considered enterprise
     * data and protected. These locations will be considered a safe destination for
     * enterprise data to be shared to.”</i>
     * 
     * @return property enterpriseNetworkDomainNames
     */
    @Property(name="enterpriseNetworkDomainNames")
    @JsonIgnore
    public CollectionPage<String> getEnterpriseNetworkDomainNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, enterpriseNetworkDomainNames, Optional.ofNullable(enterpriseNetworkDomainNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Contains a list of enterprise resource domains hosted in the cloud that need to
     * be protected. Connections to these resources are considered enterprise data. If
     * a proxy is paired with a cloud resource, traffic to the cloud resource will be
     * routed through the enterprise network via the denoted proxy server (on Port 80).
     * A proxy server used for this purpose must also be configured using the
     * EnterpriseInternalProxyServers policy. This collection can contain a maximum of
     * 500 elements.”</i>
     * 
     * @return property enterpriseCloudResources
     */
    @Property(name="enterpriseCloudResources")
    @JsonIgnore
    public CollectionPage<ProxiedDomain> getEnterpriseCloudResources() {
        return new CollectionPage<ProxiedDomain>(contextPath, ProxiedDomain.class, enterpriseCloudResources, Optional.ofNullable(enterpriseCloudResourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Contains a list of enterprise resource domains hosted in the cloud that need to
     * be protected. Connections to these resources are considered enterprise data. If
     * a proxy is paired with a cloud resource, traffic to the cloud resource will be
     * routed through the enterprise network via the denoted proxy server (on Port 80).
     * A proxy server used for this purpose must also be configured using the
     * EnterpriseInternalProxyServers policy. This collection can contain a maximum of
     * 500 elements.”</i>
     * 
     * @return property enterpriseCloudResources
     */
    @Property(name="enterpriseCloudResources")
    @JsonIgnore
    public CollectionPage<ProxiedDomain> getEnterpriseCloudResources(HttpRequestOptions options) {
        return new CollectionPage<ProxiedDomain>(contextPath, ProxiedDomain.class, enterpriseCloudResources, Optional.ofNullable(enterpriseCloudResourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Sets the enterprise IP ranges that define the computers in the enterprise
     * network. Data that comes from those computers will be considered part of the
     * enterprise and protected. These locations will be considered a safe destination
     * for enterprise data to be shared to. This collection can contain a maximum of
     * 500 elements.”</i>
     * 
     * @return property enterpriseIPRanges
     */
    @Property(name="enterpriseIPRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getEnterpriseIPRanges() {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, enterpriseIPRanges, Optional.ofNullable(enterpriseIPRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Sets the enterprise IP ranges that define the computers in the enterprise
     * network. Data that comes from those computers will be considered part of the
     * enterprise and protected. These locations will be considered a safe destination
     * for enterprise data to be shared to. This collection can contain a maximum of
     * 500 elements.”</i>
     * 
     * @return property enterpriseIPRanges
     */
    @Property(name="enterpriseIPRanges")
    @JsonIgnore
    public CollectionPage<IpRange> getEnterpriseIPRanges(HttpRequestOptions options) {
        return new CollectionPage<IpRange>(contextPath, IpRange.class, enterpriseIPRanges, Optional.ofNullable(enterpriseIPRangesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“This is the comma-separated list of internal proxy servers. For example, "157.54
     * .14.28, 157.54.11.118, 10.202.14.167, 157.53.14.163, 157.69.210.59". These
     * proxies have been configured by the admin to connect to specific resources on
     * the Internet. They are considered to be enterprise network locations. The
     * proxies are only leveraged in configuring the EnterpriseCloudResources policy to
     * force traffic to the matched cloud resources through these proxies.”</i>
     * 
     * @return property enterpriseInternalProxyServers
     */
    @Property(name="enterpriseInternalProxyServers")
    @JsonIgnore
    public CollectionPage<String> getEnterpriseInternalProxyServers() {
        return new CollectionPage<String>(contextPath, String.class, enterpriseInternalProxyServers, Optional.ofNullable(enterpriseInternalProxyServersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“This is the comma-separated list of internal proxy servers. For example, "157.54
     * .14.28, 157.54.11.118, 10.202.14.167, 157.53.14.163, 157.69.210.59". These
     * proxies have been configured by the admin to connect to specific resources on
     * the Internet. They are considered to be enterprise network locations. The
     * proxies are only leveraged in configuring the EnterpriseCloudResources policy to
     * force traffic to the matched cloud resources through these proxies.”</i>
     * 
     * @return property enterpriseInternalProxyServers
     */
    @Property(name="enterpriseInternalProxyServers")
    @JsonIgnore
    public CollectionPage<String> getEnterpriseInternalProxyServers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, enterpriseInternalProxyServers, Optional.ofNullable(enterpriseInternalProxyServersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Boolean value that tells the client to accept the configured list and not to use
     * heuristics to attempt to find other subnets. Default is false.”</i>
     * 
     * @return property enterpriseIPRangesAreAuthoritative
     */
    @Property(name="enterpriseIPRangesAreAuthoritative")
    @JsonIgnore
    public Optional<Boolean> getEnterpriseIPRangesAreAuthoritative() {
        return Optional.ofNullable(enterpriseIPRangesAreAuthoritative);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseIPRangesAreAuthoritative} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Boolean value that tells the client to accept the configured list and not to use
     * heuristics to attempt to find other subnets. Default is false.”</i>
     * 
     * @param enterpriseIPRangesAreAuthoritative
     *            new value of {@code enterpriseIPRangesAreAuthoritative} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseIPRangesAreAuthoritative} field changed
     */
    public WindowsNetworkIsolationPolicy withEnterpriseIPRangesAreAuthoritative(Boolean enterpriseIPRangesAreAuthoritative) {
        WindowsNetworkIsolationPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsNetworkIsolationPolicy");
        _x.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
        return _x;
    }

    /**
     * <i>“This is a list of proxy servers. Any server not on this list is considered non-
     * enterprise.”</i>
     * 
     * @return property enterpriseProxyServers
     */
    @Property(name="enterpriseProxyServers")
    @JsonIgnore
    public CollectionPage<String> getEnterpriseProxyServers() {
        return new CollectionPage<String>(contextPath, String.class, enterpriseProxyServers, Optional.ofNullable(enterpriseProxyServersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“This is a list of proxy servers. Any server not on this list is considered non-
     * enterprise.”</i>
     * 
     * @return property enterpriseProxyServers
     */
    @Property(name="enterpriseProxyServers")
    @JsonIgnore
    public CollectionPage<String> getEnterpriseProxyServers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, enterpriseProxyServers, Optional.ofNullable(enterpriseProxyServersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Boolean value that tells the client to accept the configured list of proxies and
     * not try to detect other work proxies. Default is false”</i>
     * 
     * @return property enterpriseProxyServersAreAuthoritative
     */
    @Property(name="enterpriseProxyServersAreAuthoritative")
    @JsonIgnore
    public Optional<Boolean> getEnterpriseProxyServersAreAuthoritative() {
        return Optional.ofNullable(enterpriseProxyServersAreAuthoritative);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseProxyServersAreAuthoritative} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Boolean value that tells the client to accept the configured list of proxies and
     * not try to detect other work proxies. Default is false”</i>
     * 
     * @param enterpriseProxyServersAreAuthoritative
     *            new value of {@code enterpriseProxyServersAreAuthoritative} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseProxyServersAreAuthoritative} field changed
     */
    public WindowsNetworkIsolationPolicy withEnterpriseProxyServersAreAuthoritative(Boolean enterpriseProxyServersAreAuthoritative) {
        WindowsNetworkIsolationPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsNetworkIsolationPolicy");
        _x.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
        return _x;
    }

    /**
     * <i>“List of domain names that can used for work or personal resource.”</i>
     * 
     * @return property neutralDomainResources
     */
    @Property(name="neutralDomainResources")
    @JsonIgnore
    public CollectionPage<String> getNeutralDomainResources() {
        return new CollectionPage<String>(contextPath, String.class, neutralDomainResources, Optional.ofNullable(neutralDomainResourcesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of domain names that can used for work or personal resource.”</i>
     * 
     * @return property neutralDomainResources
     */
    @Property(name="neutralDomainResources")
    @JsonIgnore
    public CollectionPage<String> getNeutralDomainResources(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, neutralDomainResources, Optional.ofNullable(neutralDomainResourcesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> enterpriseNetworkDomainNames;
        private String enterpriseNetworkDomainNamesNextLink;
        private List<ProxiedDomain> enterpriseCloudResources;
        private String enterpriseCloudResourcesNextLink;
        private List<IpRange> enterpriseIPRanges;
        private String enterpriseIPRangesNextLink;
        private List<String> enterpriseInternalProxyServers;
        private String enterpriseInternalProxyServersNextLink;
        private Boolean enterpriseIPRangesAreAuthoritative;
        private List<String> enterpriseProxyServers;
        private String enterpriseProxyServersNextLink;
        private Boolean enterpriseProxyServersAreAuthoritative;
        private List<String> neutralDomainResources;
        private String neutralDomainResourcesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“This is the list of domains that comprise the boundaries of the enterprise. Data
         * from one of these domains that is sent to a device will be considered enterprise
         * data and protected. These locations will be considered a safe destination for
         * enterprise data to be shared to.”</i>
         * 
         * @param enterpriseNetworkDomainNames
         *            value of {@code enterpriseNetworkDomainNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseNetworkDomainNames(List<String> enterpriseNetworkDomainNames) {
            this.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
            this.changedFields = changedFields.add("enterpriseNetworkDomainNames");
            return this;
        }

        /**
         * <i>“This is the list of domains that comprise the boundaries of the enterprise. Data
         * from one of these domains that is sent to a device will be considered enterprise
         * data and protected. These locations will be considered a safe destination for
         * enterprise data to be shared to.”</i>
         * 
         * @param enterpriseNetworkDomainNames
         *            value of {@code enterpriseNetworkDomainNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseNetworkDomainNames(String... enterpriseNetworkDomainNames) {
            return enterpriseNetworkDomainNames(Arrays.asList(enterpriseNetworkDomainNames));
        }

        /**
         * <i>“This is the list of domains that comprise the boundaries of the enterprise. Data
         * from one of these domains that is sent to a device will be considered enterprise
         * data and protected. These locations will be considered a safe destination for
         * enterprise data to be shared to.”</i>
         * 
         * @param enterpriseNetworkDomainNamesNextLink
         *            value of {@code enterpriseNetworkDomainNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseNetworkDomainNamesNextLink(String enterpriseNetworkDomainNamesNextLink) {
            this.enterpriseNetworkDomainNamesNextLink = enterpriseNetworkDomainNamesNextLink;
            this.changedFields = changedFields.add("enterpriseNetworkDomainNames");
            return this;
        }

        /**
         * <i>“Contains a list of enterprise resource domains hosted in the cloud that need to
         * be protected. Connections to these resources are considered enterprise data. If
         * a proxy is paired with a cloud resource, traffic to the cloud resource will be
         * routed through the enterprise network via the denoted proxy server (on Port 80).
         * A proxy server used for this purpose must also be configured using the
         * EnterpriseInternalProxyServers policy. This collection can contain a maximum of
         * 500 elements.”</i>
         * 
         * @param enterpriseCloudResources
         *            value of {@code enterpriseCloudResources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudResources(List<ProxiedDomain> enterpriseCloudResources) {
            this.enterpriseCloudResources = enterpriseCloudResources;
            this.changedFields = changedFields.add("enterpriseCloudResources");
            return this;
        }

        /**
         * <i>“Contains a list of enterprise resource domains hosted in the cloud that need to
         * be protected. Connections to these resources are considered enterprise data. If
         * a proxy is paired with a cloud resource, traffic to the cloud resource will be
         * routed through the enterprise network via the denoted proxy server (on Port 80).
         * A proxy server used for this purpose must also be configured using the
         * EnterpriseInternalProxyServers policy. This collection can contain a maximum of
         * 500 elements.”</i>
         * 
         * @param enterpriseCloudResources
         *            value of {@code enterpriseCloudResources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudResources(ProxiedDomain... enterpriseCloudResources) {
            return enterpriseCloudResources(Arrays.asList(enterpriseCloudResources));
        }

        /**
         * <i>“Contains a list of enterprise resource domains hosted in the cloud that need to
         * be protected. Connections to these resources are considered enterprise data. If
         * a proxy is paired with a cloud resource, traffic to the cloud resource will be
         * routed through the enterprise network via the denoted proxy server (on Port 80).
         * A proxy server used for this purpose must also be configured using the
         * EnterpriseInternalProxyServers policy. This collection can contain a maximum of
         * 500 elements.”</i>
         * 
         * @param enterpriseCloudResourcesNextLink
         *            value of {@code enterpriseCloudResources@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudResourcesNextLink(String enterpriseCloudResourcesNextLink) {
            this.enterpriseCloudResourcesNextLink = enterpriseCloudResourcesNextLink;
            this.changedFields = changedFields.add("enterpriseCloudResources");
            return this;
        }

        /**
         * <i>“Sets the enterprise IP ranges that define the computers in the enterprise
         * network. Data that comes from those computers will be considered part of the
         * enterprise and protected. These locations will be considered a safe destination
         * for enterprise data to be shared to. This collection can contain a maximum of
         * 500 elements.”</i>
         * 
         * @param enterpriseIPRanges
         *            value of {@code enterpriseIPRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseIPRanges(List<IpRange> enterpriseIPRanges) {
            this.enterpriseIPRanges = enterpriseIPRanges;
            this.changedFields = changedFields.add("enterpriseIPRanges");
            return this;
        }

        /**
         * <i>“Sets the enterprise IP ranges that define the computers in the enterprise
         * network. Data that comes from those computers will be considered part of the
         * enterprise and protected. These locations will be considered a safe destination
         * for enterprise data to be shared to. This collection can contain a maximum of
         * 500 elements.”</i>
         * 
         * @param enterpriseIPRanges
         *            value of {@code enterpriseIPRanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseIPRanges(IpRange... enterpriseIPRanges) {
            return enterpriseIPRanges(Arrays.asList(enterpriseIPRanges));
        }

        /**
         * <i>“Sets the enterprise IP ranges that define the computers in the enterprise
         * network. Data that comes from those computers will be considered part of the
         * enterprise and protected. These locations will be considered a safe destination
         * for enterprise data to be shared to. This collection can contain a maximum of
         * 500 elements.”</i>
         * 
         * @param enterpriseIPRangesNextLink
         *            value of {@code enterpriseIPRanges@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseIPRangesNextLink(String enterpriseIPRangesNextLink) {
            this.enterpriseIPRangesNextLink = enterpriseIPRangesNextLink;
            this.changedFields = changedFields.add("enterpriseIPRanges");
            return this;
        }

        /**
         * <i>“This is the comma-separated list of internal proxy servers. For example, "157.54
         * .14.28, 157.54.11.118, 10.202.14.167, 157.53.14.163, 157.69.210.59". These
         * proxies have been configured by the admin to connect to specific resources on
         * the Internet. They are considered to be enterprise network locations. The
         * proxies are only leveraged in configuring the EnterpriseCloudResources policy to
         * force traffic to the matched cloud resources through these proxies.”</i>
         * 
         * @param enterpriseInternalProxyServers
         *            value of {@code enterpriseInternalProxyServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseInternalProxyServers(List<String> enterpriseInternalProxyServers) {
            this.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
            this.changedFields = changedFields.add("enterpriseInternalProxyServers");
            return this;
        }

        /**
         * <i>“This is the comma-separated list of internal proxy servers. For example, "157.54
         * .14.28, 157.54.11.118, 10.202.14.167, 157.53.14.163, 157.69.210.59". These
         * proxies have been configured by the admin to connect to specific resources on
         * the Internet. They are considered to be enterprise network locations. The
         * proxies are only leveraged in configuring the EnterpriseCloudResources policy to
         * force traffic to the matched cloud resources through these proxies.”</i>
         * 
         * @param enterpriseInternalProxyServers
         *            value of {@code enterpriseInternalProxyServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseInternalProxyServers(String... enterpriseInternalProxyServers) {
            return enterpriseInternalProxyServers(Arrays.asList(enterpriseInternalProxyServers));
        }

        /**
         * <i>“This is the comma-separated list of internal proxy servers. For example, "157.54
         * .14.28, 157.54.11.118, 10.202.14.167, 157.53.14.163, 157.69.210.59". These
         * proxies have been configured by the admin to connect to specific resources on
         * the Internet. They are considered to be enterprise network locations. The
         * proxies are only leveraged in configuring the EnterpriseCloudResources policy to
         * force traffic to the matched cloud resources through these proxies.”</i>
         * 
         * @param enterpriseInternalProxyServersNextLink
         *            value of {@code enterpriseInternalProxyServers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseInternalProxyServersNextLink(String enterpriseInternalProxyServersNextLink) {
            this.enterpriseInternalProxyServersNextLink = enterpriseInternalProxyServersNextLink;
            this.changedFields = changedFields.add("enterpriseInternalProxyServers");
            return this;
        }

        /**
         * <i>“Boolean value that tells the client to accept the configured list and not to use
         * heuristics to attempt to find other subnets. Default is false.”</i>
         * 
         * @param enterpriseIPRangesAreAuthoritative
         *            value of {@code enterpriseIPRangesAreAuthoritative} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseIPRangesAreAuthoritative(Boolean enterpriseIPRangesAreAuthoritative) {
            this.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
            this.changedFields = changedFields.add("enterpriseIPRangesAreAuthoritative");
            return this;
        }

        /**
         * <i>“This is a list of proxy servers. Any server not on this list is considered non-
         * enterprise.”</i>
         * 
         * @param enterpriseProxyServers
         *            value of {@code enterpriseProxyServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseProxyServers(List<String> enterpriseProxyServers) {
            this.enterpriseProxyServers = enterpriseProxyServers;
            this.changedFields = changedFields.add("enterpriseProxyServers");
            return this;
        }

        /**
         * <i>“This is a list of proxy servers. Any server not on this list is considered non-
         * enterprise.”</i>
         * 
         * @param enterpriseProxyServers
         *            value of {@code enterpriseProxyServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseProxyServers(String... enterpriseProxyServers) {
            return enterpriseProxyServers(Arrays.asList(enterpriseProxyServers));
        }

        /**
         * <i>“This is a list of proxy servers. Any server not on this list is considered non-
         * enterprise.”</i>
         * 
         * @param enterpriseProxyServersNextLink
         *            value of {@code enterpriseProxyServers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseProxyServersNextLink(String enterpriseProxyServersNextLink) {
            this.enterpriseProxyServersNextLink = enterpriseProxyServersNextLink;
            this.changedFields = changedFields.add("enterpriseProxyServers");
            return this;
        }

        /**
         * <i>“Boolean value that tells the client to accept the configured list of proxies and
         * not try to detect other work proxies. Default is false”</i>
         * 
         * @param enterpriseProxyServersAreAuthoritative
         *            value of {@code enterpriseProxyServersAreAuthoritative} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseProxyServersAreAuthoritative(Boolean enterpriseProxyServersAreAuthoritative) {
            this.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
            this.changedFields = changedFields.add("enterpriseProxyServersAreAuthoritative");
            return this;
        }

        /**
         * <i>“List of domain names that can used for work or personal resource.”</i>
         * 
         * @param neutralDomainResources
         *            value of {@code neutralDomainResources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder neutralDomainResources(List<String> neutralDomainResources) {
            this.neutralDomainResources = neutralDomainResources;
            this.changedFields = changedFields.add("neutralDomainResources");
            return this;
        }

        /**
         * <i>“List of domain names that can used for work or personal resource.”</i>
         * 
         * @param neutralDomainResources
         *            value of {@code neutralDomainResources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder neutralDomainResources(String... neutralDomainResources) {
            return neutralDomainResources(Arrays.asList(neutralDomainResources));
        }

        /**
         * <i>“List of domain names that can used for work or personal resource.”</i>
         * 
         * @param neutralDomainResourcesNextLink
         *            value of {@code neutralDomainResources@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder neutralDomainResourcesNextLink(String neutralDomainResourcesNextLink) {
            this.neutralDomainResourcesNextLink = neutralDomainResourcesNextLink;
            this.changedFields = changedFields.add("neutralDomainResources");
            return this;
        }

        public WindowsNetworkIsolationPolicy build() {
            WindowsNetworkIsolationPolicy _x = new WindowsNetworkIsolationPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsNetworkIsolationPolicy";
            _x.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
            _x.enterpriseNetworkDomainNamesNextLink = enterpriseNetworkDomainNamesNextLink;
            _x.enterpriseCloudResources = enterpriseCloudResources;
            _x.enterpriseCloudResourcesNextLink = enterpriseCloudResourcesNextLink;
            _x.enterpriseIPRanges = enterpriseIPRanges;
            _x.enterpriseIPRangesNextLink = enterpriseIPRangesNextLink;
            _x.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
            _x.enterpriseInternalProxyServersNextLink = enterpriseInternalProxyServersNextLink;
            _x.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
            _x.enterpriseProxyServers = enterpriseProxyServers;
            _x.enterpriseProxyServersNextLink = enterpriseProxyServersNextLink;
            _x.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
            _x.neutralDomainResources = neutralDomainResources;
            _x.neutralDomainResourcesNextLink = neutralDomainResourcesNextLink;
            return _x;
        }
    }

    private WindowsNetworkIsolationPolicy _copy() {
        WindowsNetworkIsolationPolicy _x = new WindowsNetworkIsolationPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
        _x.enterpriseCloudResources = enterpriseCloudResources;
        _x.enterpriseIPRanges = enterpriseIPRanges;
        _x.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
        _x.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
        _x.enterpriseProxyServers = enterpriseProxyServers;
        _x.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
        _x.neutralDomainResources = neutralDomainResources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsNetworkIsolationPolicy[");
        b.append("enterpriseNetworkDomainNames=");
        b.append(this.enterpriseNetworkDomainNames);
        b.append(", ");
        b.append("enterpriseCloudResources=");
        b.append(this.enterpriseCloudResources);
        b.append(", ");
        b.append("enterpriseIPRanges=");
        b.append(this.enterpriseIPRanges);
        b.append(", ");
        b.append("enterpriseInternalProxyServers=");
        b.append(this.enterpriseInternalProxyServers);
        b.append(", ");
        b.append("enterpriseIPRangesAreAuthoritative=");
        b.append(this.enterpriseIPRangesAreAuthoritative);
        b.append(", ");
        b.append("enterpriseProxyServers=");
        b.append(this.enterpriseProxyServers);
        b.append(", ");
        b.append("enterpriseProxyServersAreAuthoritative=");
        b.append(this.enterpriseProxyServersAreAuthoritative);
        b.append(", ");
        b.append("neutralDomainResources=");
        b.append(this.neutralDomainResources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
