package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The minimum operating system required for a Windows mobile app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "v8_0", 
    "v8_1", 
    "v10_0", 
    "v10_1607", 
    "v10_1703", 
    "v10_1709", 
    "v10_1803", 
    "v10_1809", 
    "v10_1903"})
@JsonInclude(Include.NON_NULL)
public class WindowsMinimumOperatingSystem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("v8_0")
    protected Boolean v8_0;

    @JsonProperty("v8_1")
    protected Boolean v8_1;

    @JsonProperty("v10_0")
    protected Boolean v10_0;

    @JsonProperty("v10_1607")
    protected Boolean v10_1607;

    @JsonProperty("v10_1703")
    protected Boolean v10_1703;

    @JsonProperty("v10_1709")
    protected Boolean v10_1709;

    @JsonProperty("v10_1803")
    protected Boolean v10_1803;

    @JsonProperty("v10_1809")
    protected Boolean v10_1809;

    @JsonProperty("v10_1903")
    protected Boolean v10_1903;

    protected WindowsMinimumOperatingSystem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMinimumOperatingSystem";
    }

    /**
     * <i>“Windows version 8.0 or later.”</i>
     * 
     * @return property v8_0
     */
    @Property(name="v8_0")
    @JsonIgnore
    public Optional<Boolean> getV8_0() {
        return Optional.ofNullable(v8_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v8_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows version 8.0 or later.”</i>
     * 
     * @param v8_0
     *            new value of {@code v8_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v8_0} field changed
     */
    public WindowsMinimumOperatingSystem withV8_0(Boolean v8_0) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v8_0 = v8_0;
        return _x;
    }

    /**
     * <i>“Windows version 8.1 or later.”</i>
     * 
     * @return property v8_1
     */
    @Property(name="v8_1")
    @JsonIgnore
    public Optional<Boolean> getV8_1() {
        return Optional.ofNullable(v8_1);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v8_1} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows version 8.1 or later.”</i>
     * 
     * @param v8_1
     *            new value of {@code v8_1} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v8_1} field changed
     */
    public WindowsMinimumOperatingSystem withV8_1(Boolean v8_1) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v8_1 = v8_1;
        return _x;
    }

    /**
     * <i>“Windows version 10.0 or later.”</i>
     * 
     * @return property v10_0
     */
    @Property(name="v10_0")
    @JsonIgnore
    public Optional<Boolean> getV10_0() {
        return Optional.ofNullable(v10_0);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_0} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows version 10.0 or later.”</i>
     * 
     * @param v10_0
     *            new value of {@code v10_0} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_0} field changed
     */
    public WindowsMinimumOperatingSystem withV10_0(Boolean v10_0) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v10_0 = v10_0;
        return _x;
    }

    /**
     * <i>“Windows 10 1607 or later.”</i>
     * 
     * @return property v10_1607
     */
    @Property(name="v10_1607")
    @JsonIgnore
    public Optional<Boolean> getV10_1607() {
        return Optional.ofNullable(v10_1607);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_1607} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows 10 1607 or later.”</i>
     * 
     * @param v10_1607
     *            new value of {@code v10_1607} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_1607} field changed
     */
    public WindowsMinimumOperatingSystem withV10_1607(Boolean v10_1607) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v10_1607 = v10_1607;
        return _x;
    }

    /**
     * <i>“Windows 10 1703 or later.”</i>
     * 
     * @return property v10_1703
     */
    @Property(name="v10_1703")
    @JsonIgnore
    public Optional<Boolean> getV10_1703() {
        return Optional.ofNullable(v10_1703);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_1703} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows 10 1703 or later.”</i>
     * 
     * @param v10_1703
     *            new value of {@code v10_1703} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_1703} field changed
     */
    public WindowsMinimumOperatingSystem withV10_1703(Boolean v10_1703) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v10_1703 = v10_1703;
        return _x;
    }

    /**
     * <i>“Windows 10 1709 or later.”</i>
     * 
     * @return property v10_1709
     */
    @Property(name="v10_1709")
    @JsonIgnore
    public Optional<Boolean> getV10_1709() {
        return Optional.ofNullable(v10_1709);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_1709} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows 10 1709 or later.”</i>
     * 
     * @param v10_1709
     *            new value of {@code v10_1709} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_1709} field changed
     */
    public WindowsMinimumOperatingSystem withV10_1709(Boolean v10_1709) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v10_1709 = v10_1709;
        return _x;
    }

    /**
     * <i>“Windows 10 1803 or later.”</i>
     * 
     * @return property v10_1803
     */
    @Property(name="v10_1803")
    @JsonIgnore
    public Optional<Boolean> getV10_1803() {
        return Optional.ofNullable(v10_1803);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_1803} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows 10 1803 or later.”</i>
     * 
     * @param v10_1803
     *            new value of {@code v10_1803} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_1803} field changed
     */
    public WindowsMinimumOperatingSystem withV10_1803(Boolean v10_1803) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v10_1803 = v10_1803;
        return _x;
    }

    /**
     * <i>“Windows 10 1809 or later.”</i>
     * 
     * @return property v10_1809
     */
    @Property(name="v10_1809")
    @JsonIgnore
    public Optional<Boolean> getV10_1809() {
        return Optional.ofNullable(v10_1809);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_1809} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows 10 1809 or later.”</i>
     * 
     * @param v10_1809
     *            new value of {@code v10_1809} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_1809} field changed
     */
    public WindowsMinimumOperatingSystem withV10_1809(Boolean v10_1809) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v10_1809 = v10_1809;
        return _x;
    }

    /**
     * <i>“Windows 10 1903 or later.”</i>
     * 
     * @return property v10_1903
     */
    @Property(name="v10_1903")
    @JsonIgnore
    public Optional<Boolean> getV10_1903() {
        return Optional.ofNullable(v10_1903);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code v10_1903} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Windows 10 1903 or later.”</i>
     * 
     * @param v10_1903
     *            new value of {@code v10_1903} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code v10_1903} field changed
     */
    public WindowsMinimumOperatingSystem withV10_1903(Boolean v10_1903) {
        WindowsMinimumOperatingSystem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMinimumOperatingSystem");
        _x.v10_1903 = v10_1903;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean v8_0;
        private Boolean v8_1;
        private Boolean v10_0;
        private Boolean v10_1607;
        private Boolean v10_1703;
        private Boolean v10_1709;
        private Boolean v10_1803;
        private Boolean v10_1809;
        private Boolean v10_1903;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Windows version 8.0 or later.”</i>
         * 
         * @param v8_0
         *            value of {@code v8_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v8_0(Boolean v8_0) {
            this.v8_0 = v8_0;
            this.changedFields = changedFields.add("v8_0");
            return this;
        }

        /**
         * <i>“Windows version 8.1 or later.”</i>
         * 
         * @param v8_1
         *            value of {@code v8_1} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v8_1(Boolean v8_1) {
            this.v8_1 = v8_1;
            this.changedFields = changedFields.add("v8_1");
            return this;
        }

        /**
         * <i>“Windows version 10.0 or later.”</i>
         * 
         * @param v10_0
         *            value of {@code v10_0} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_0(Boolean v10_0) {
            this.v10_0 = v10_0;
            this.changedFields = changedFields.add("v10_0");
            return this;
        }

        /**
         * <i>“Windows 10 1607 or later.”</i>
         * 
         * @param v10_1607
         *            value of {@code v10_1607} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_1607(Boolean v10_1607) {
            this.v10_1607 = v10_1607;
            this.changedFields = changedFields.add("v10_1607");
            return this;
        }

        /**
         * <i>“Windows 10 1703 or later.”</i>
         * 
         * @param v10_1703
         *            value of {@code v10_1703} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_1703(Boolean v10_1703) {
            this.v10_1703 = v10_1703;
            this.changedFields = changedFields.add("v10_1703");
            return this;
        }

        /**
         * <i>“Windows 10 1709 or later.”</i>
         * 
         * @param v10_1709
         *            value of {@code v10_1709} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_1709(Boolean v10_1709) {
            this.v10_1709 = v10_1709;
            this.changedFields = changedFields.add("v10_1709");
            return this;
        }

        /**
         * <i>“Windows 10 1803 or later.”</i>
         * 
         * @param v10_1803
         *            value of {@code v10_1803} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_1803(Boolean v10_1803) {
            this.v10_1803 = v10_1803;
            this.changedFields = changedFields.add("v10_1803");
            return this;
        }

        /**
         * <i>“Windows 10 1809 or later.”</i>
         * 
         * @param v10_1809
         *            value of {@code v10_1809} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_1809(Boolean v10_1809) {
            this.v10_1809 = v10_1809;
            this.changedFields = changedFields.add("v10_1809");
            return this;
        }

        /**
         * <i>“Windows 10 1903 or later.”</i>
         * 
         * @param v10_1903
         *            value of {@code v10_1903} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder v10_1903(Boolean v10_1903) {
            this.v10_1903 = v10_1903;
            this.changedFields = changedFields.add("v10_1903");
            return this;
        }

        public WindowsMinimumOperatingSystem build() {
            WindowsMinimumOperatingSystem _x = new WindowsMinimumOperatingSystem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsMinimumOperatingSystem";
            _x.v8_0 = v8_0;
            _x.v8_1 = v8_1;
            _x.v10_0 = v10_0;
            _x.v10_1607 = v10_1607;
            _x.v10_1703 = v10_1703;
            _x.v10_1709 = v10_1709;
            _x.v10_1803 = v10_1803;
            _x.v10_1809 = v10_1809;
            _x.v10_1903 = v10_1903;
            return _x;
        }
    }

    private WindowsMinimumOperatingSystem _copy() {
        WindowsMinimumOperatingSystem _x = new WindowsMinimumOperatingSystem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.v8_0 = v8_0;
        _x.v8_1 = v8_1;
        _x.v10_0 = v10_0;
        _x.v10_1607 = v10_1607;
        _x.v10_1703 = v10_1703;
        _x.v10_1709 = v10_1709;
        _x.v10_1803 = v10_1803;
        _x.v10_1809 = v10_1809;
        _x.v10_1903 = v10_1903;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMinimumOperatingSystem[");
        b.append("v8_0=");
        b.append(this.v8_0);
        b.append(", ");
        b.append("v8_1=");
        b.append(this.v8_1);
        b.append(", ");
        b.append("v10_0=");
        b.append(this.v10_0);
        b.append(", ");
        b.append("v10_1607=");
        b.append(this.v10_1607);
        b.append(", ");
        b.append("v10_1703=");
        b.append(this.v10_1703);
        b.append(", ");
        b.append("v10_1709=");
        b.append(this.v10_1709);
        b.append(", ");
        b.append("v10_1803=");
        b.append(this.v10_1803);
        b.append(", ");
        b.append("v10_1809=");
        b.append(this.v10_1809);
        b.append(", ");
        b.append("v10_1903=");
        b.append(this.v10_1903);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
