package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsMalwareExecutionState;


/**
 * <i>“Windows malware execution state summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "executionState", 
    "deviceCount", 
    "lastUpdateDateTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsMalwareExecutionStateCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("executionState")
    protected WindowsMalwareExecutionState executionState;

    @JsonProperty("deviceCount")
    protected Integer deviceCount;

    @JsonProperty("lastUpdateDateTime")
    protected OffsetDateTime lastUpdateDateTime;

    protected WindowsMalwareExecutionStateCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsMalwareExecutionStateCount";
    }

    /**
     * <i>“Malware execution state”</i>
     * 
     * @return property executionState
     */
    @Property(name="executionState")
    @JsonIgnore
    public Optional<WindowsMalwareExecutionState> getExecutionState() {
        return Optional.ofNullable(executionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code executionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Malware execution state”</i>
     * 
     * @param executionState
     *            new value of {@code executionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code executionState} field changed
     */
    public WindowsMalwareExecutionStateCount withExecutionState(WindowsMalwareExecutionState executionState) {
        WindowsMalwareExecutionStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareExecutionStateCount");
        _x.executionState = executionState;
        return _x;
    }

    /**
     * <i>“Count of devices with malware detections for this malware execution state”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Integer> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of devices with malware detections for this malware execution state”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public WindowsMalwareExecutionStateCount withDeviceCount(Integer deviceCount) {
        WindowsMalwareExecutionStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareExecutionStateCount");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Timestamp of the last update for the device count in UTC”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public WindowsMalwareExecutionStateCount withLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        WindowsMalwareExecutionStateCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsMalwareExecutionStateCount");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsMalwareExecutionState executionState;
        private Integer deviceCount;
        private OffsetDateTime lastUpdateDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Malware execution state”</i>
         * 
         * @param executionState
         *            value of {@code executionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder executionState(WindowsMalwareExecutionState executionState) {
            this.executionState = executionState;
            this.changedFields = changedFields.add("executionState");
            return this;
        }

        /**
         * <i>“Count of devices with malware detections for this malware execution state”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Integer deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“The Timestamp of the last update for the device count in UTC”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        public WindowsMalwareExecutionStateCount build() {
            WindowsMalwareExecutionStateCount _x = new WindowsMalwareExecutionStateCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsMalwareExecutionStateCount";
            _x.executionState = executionState;
            _x.deviceCount = deviceCount;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            return _x;
        }
    }

    private WindowsMalwareExecutionStateCount _copy() {
        WindowsMalwareExecutionStateCount _x = new WindowsMalwareExecutionStateCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.executionState = executionState;
        _x.deviceCount = deviceCount;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsMalwareExecutionStateCount[");
        b.append("executionState=");
        b.append(this.executionState);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
