package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsAppStartLayoutTileSize;
import odata.msgraph.client.beta.enums.WindowsKioskAppType;


/**
 * <i>“The base class for a type of apps”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appUserModelId", 
    "appId", 
    "containedAppId"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskUWPApp extends WindowsKioskAppBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("appUserModelId")
    protected String appUserModelId;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("containedAppId")
    protected String containedAppId;

    protected WindowsKioskUWPApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskUWPApp";
    }

    /**
     * <i>“This is the only Application User Model ID (AUMID) that will be available to
     * launch use while in Kiosk Mode”</i>
     * 
     * @return property appUserModelId
     */
    @Property(name="appUserModelId")
    @JsonIgnore
    public Optional<String> getAppUserModelId() {
        return Optional.ofNullable(appUserModelId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appUserModelId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This is the only Application User Model ID (AUMID) that will be available to
     * launch use while in Kiosk Mode”</i>
     * 
     * @param appUserModelId
     *            new value of {@code appUserModelId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appUserModelId} field changed
     */
    public WindowsKioskUWPApp withAppUserModelId(String appUserModelId) {
        WindowsKioskUWPApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskUWPApp");
        _x.appUserModelId = appUserModelId;
        return _x;
    }

    /**
     * <i>“This references an Intune App that will be target to the same assignments as
     * Kiosk configuration”</i>
     * 
     * @return property appId
     */
    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This references an Intune App that will be target to the same assignments as
     * Kiosk configuration”</i>
     * 
     * @param appId
     *            new value of {@code appId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appId} field changed
     */
    public WindowsKioskUWPApp withAppId(String appId) {
        WindowsKioskUWPApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskUWPApp");
        _x.appId = appId;
        return _x;
    }

    /**
     * <i>“This references an contained App from an Intune App”</i>
     * 
     * @return property containedAppId
     */
    @Property(name="containedAppId")
    @JsonIgnore
    public Optional<String> getContainedAppId() {
        return Optional.ofNullable(containedAppId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code containedAppId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This references an contained App from an Intune App”</i>
     * 
     * @param containedAppId
     *            new value of {@code containedAppId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code containedAppId} field changed
     */
    public WindowsKioskUWPApp withContainedAppId(String containedAppId) {
        WindowsKioskUWPApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskUWPApp");
        _x.containedAppId = containedAppId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskUWPApp() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsAppStartLayoutTileSize startLayoutTileSize;
        private String name;
        private WindowsKioskAppType appType;
        private Boolean autoLaunch;
        private String appUserModelId;
        private String appId;
        private String containedAppId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder startLayoutTileSize(WindowsAppStartLayoutTileSize startLayoutTileSize) {
            this.startLayoutTileSize = startLayoutTileSize;
            this.changedFields = changedFields.add("startLayoutTileSize");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder appType(WindowsKioskAppType appType) {
            this.appType = appType;
            this.changedFields = changedFields.add("appType");
            return this;
        }

        public Builder autoLaunch(Boolean autoLaunch) {
            this.autoLaunch = autoLaunch;
            this.changedFields = changedFields.add("autoLaunch");
            return this;
        }

        /**
         * <i>“This is the only Application User Model ID (AUMID) that will be available to
         * launch use while in Kiosk Mode”</i>
         * 
         * @param appUserModelId
         *            value of {@code appUserModelId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appUserModelId(String appUserModelId) {
            this.appUserModelId = appUserModelId;
            this.changedFields = changedFields.add("appUserModelId");
            return this;
        }

        /**
         * <i>“This references an Intune App that will be target to the same assignments as
         * Kiosk configuration”</i>
         * 
         * @param appId
         *            value of {@code appId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        /**
         * <i>“This references an contained App from an Intune App”</i>
         * 
         * @param containedAppId
         *            value of {@code containedAppId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder containedAppId(String containedAppId) {
            this.containedAppId = containedAppId;
            this.changedFields = changedFields.add("containedAppId");
            return this;
        }

        public WindowsKioskUWPApp build() {
            WindowsKioskUWPApp _x = new WindowsKioskUWPApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskUWPApp";
            _x.startLayoutTileSize = startLayoutTileSize;
            _x.name = name;
            _x.appType = appType;
            _x.autoLaunch = autoLaunch;
            _x.appUserModelId = appUserModelId;
            _x.appId = appId;
            _x.containedAppId = containedAppId;
            return _x;
        }
    }

    private WindowsKioskUWPApp _copy() {
        WindowsKioskUWPApp _x = new WindowsKioskUWPApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startLayoutTileSize = startLayoutTileSize;
        _x.name = name;
        _x.appType = appType;
        _x.autoLaunch = autoLaunch;
        _x.appUserModelId = appUserModelId;
        _x.appId = appId;
        _x.containedAppId = containedAppId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskUWPApp[");
        b.append("startLayoutTileSize=");
        b.append(this.startLayoutTileSize);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("appType=");
        b.append(this.appType);
        b.append(", ");
        b.append("autoLaunch=");
        b.append(this.autoLaunch);
        b.append(", ");
        b.append("appUserModelId=");
        b.append(this.appUserModelId);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("containedAppId=");
        b.append(this.containedAppId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
