package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The class used to identify the UWP app info for the kiosk configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "uwpApp"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskSingleUWPApp extends WindowsKioskAppConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("uwpApp")
    protected WindowsKioskUWPApp uwpApp;

    protected WindowsKioskSingleUWPApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskSingleUWPApp";
    }

    /**
     * <i>“This is the only Application User Model ID (AUMID) that will be available to
     * launch use while in Kiosk Mode”</i>
     * 
     * @return property uwpApp
     */
    @Property(name="uwpApp")
    @JsonIgnore
    public Optional<WindowsKioskUWPApp> getUwpApp() {
        return Optional.ofNullable(uwpApp);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code uwpApp} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This is the only Application User Model ID (AUMID) that will be available to
     * launch use while in Kiosk Mode”</i>
     * 
     * @param uwpApp
     *            new value of {@code uwpApp} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uwpApp} field changed
     */
    public WindowsKioskSingleUWPApp withUwpApp(WindowsKioskUWPApp uwpApp) {
        WindowsKioskSingleUWPApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskSingleUWPApp");
        _x.uwpApp = uwpApp;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskSingleUWPApp() {
        return new Builder();
    }

    public static final class Builder {
        private WindowsKioskUWPApp uwpApp;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“This is the only Application User Model ID (AUMID) that will be available to
         * launch use while in Kiosk Mode”</i>
         * 
         * @param uwpApp
         *            value of {@code uwpApp} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uwpApp(WindowsKioskUWPApp uwpApp) {
            this.uwpApp = uwpApp;
            this.changedFields = changedFields.add("uwpApp");
            return this;
        }

        public WindowsKioskSingleUWPApp build() {
            WindowsKioskSingleUWPApp _x = new WindowsKioskSingleUWPApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskSingleUWPApp";
            _x.uwpApp = uwpApp;
            return _x;
        }
    }

    private WindowsKioskSingleUWPApp _copy() {
        WindowsKioskSingleUWPApp _x = new WindowsKioskSingleUWPApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.uwpApp = uwpApp;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskSingleUWPApp[");
        b.append("uwpApp=");
        b.append(this.uwpApp);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
