package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The class used to identify the MultiMode app configuration for the kiosk
 * configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "apps", 
    "showTaskBar", 
    "allowAccessToDownloadsFolder", 
    "disallowDesktopApps", 
    "startMenuLayoutXml"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskMultipleApps extends WindowsKioskAppConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("apps")
    protected List<WindowsKioskAppBase> apps;

    @JsonProperty("apps@nextLink")
    protected String appsNextLink;

    @JsonProperty("showTaskBar")
    protected Boolean showTaskBar;

    @JsonProperty("allowAccessToDownloadsFolder")
    protected Boolean allowAccessToDownloadsFolder;

    @JsonProperty("disallowDesktopApps")
    protected Boolean disallowDesktopApps;

    @JsonProperty("startMenuLayoutXml")
    protected byte[] startMenuLayoutXml;

    protected WindowsKioskMultipleApps() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskMultipleApps";
    }

    /**
     * <i>“These are the only Windows Store Apps that will be available to launch from the
     * Start menu. This collection can contain a maximum of 128 elements.”</i>
     * 
     * @return property apps
     */
    @Property(name="apps")
    @JsonIgnore
    public CollectionPage<WindowsKioskAppBase> getApps() {
        return new CollectionPage<WindowsKioskAppBase>(contextPath, WindowsKioskAppBase.class, apps, Optional.ofNullable(appsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“These are the only Windows Store Apps that will be available to launch from the
     * Start menu. This collection can contain a maximum of 128 elements.”</i>
     * 
     * @return property apps
     */
    @Property(name="apps")
    @JsonIgnore
    public CollectionPage<WindowsKioskAppBase> getApps(HttpRequestOptions options) {
        return new CollectionPage<WindowsKioskAppBase>(contextPath, WindowsKioskAppBase.class, apps, Optional.ofNullable(appsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“This setting allows the admin to specify whether the Task Bar is shown or not.”</i>
     * 
     * @return property showTaskBar
     */
    @Property(name="showTaskBar")
    @JsonIgnore
    public Optional<Boolean> getShowTaskBar() {
        return Optional.ofNullable(showTaskBar);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code showTaskBar}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This setting allows the admin to specify whether the Task Bar is shown or not.”</i>
     * 
     * @param showTaskBar
     *            new value of {@code showTaskBar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showTaskBar} field changed
     */
    public WindowsKioskMultipleApps withShowTaskBar(Boolean showTaskBar) {
        WindowsKioskMultipleApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskMultipleApps");
        _x.showTaskBar = showTaskBar;
        return _x;
    }

    /**
     * <i>“This setting allows access to Downloads folder in file explorer.”</i>
     * 
     * @return property allowAccessToDownloadsFolder
     */
    @Property(name="allowAccessToDownloadsFolder")
    @JsonIgnore
    public Optional<Boolean> getAllowAccessToDownloadsFolder() {
        return Optional.ofNullable(allowAccessToDownloadsFolder);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowAccessToDownloadsFolder} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This setting allows access to Downloads folder in file explorer.”</i>
     * 
     * @param allowAccessToDownloadsFolder
     *            new value of {@code allowAccessToDownloadsFolder} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowAccessToDownloadsFolder} field changed
     */
    public WindowsKioskMultipleApps withAllowAccessToDownloadsFolder(Boolean allowAccessToDownloadsFolder) {
        WindowsKioskMultipleApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskMultipleApps");
        _x.allowAccessToDownloadsFolder = allowAccessToDownloadsFolder;
        return _x;
    }

    /**
     * <i>“This setting indicates that desktop apps are allowed. Default to true.”</i>
     * 
     * @return property disallowDesktopApps
     */
    @Property(name="disallowDesktopApps")
    @JsonIgnore
    public Optional<Boolean> getDisallowDesktopApps() {
        return Optional.ofNullable(disallowDesktopApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disallowDesktopApps} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This setting indicates that desktop apps are allowed. Default to true.”</i>
     * 
     * @param disallowDesktopApps
     *            new value of {@code disallowDesktopApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disallowDesktopApps} field changed
     */
    public WindowsKioskMultipleApps withDisallowDesktopApps(Boolean disallowDesktopApps) {
        WindowsKioskMultipleApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskMultipleApps");
        _x.disallowDesktopApps = disallowDesktopApps;
        return _x;
    }

    /**
     * <i>“Allows admins to override the default Start layout and prevents the user from
     * changing it. The layout is modified by specifying an XML file based on a layout
     * modification schema. XML needs to be in Binary format.”</i>
     * 
     * @return property startMenuLayoutXml
     */
    @Property(name="startMenuLayoutXml")
    @JsonIgnore
    public Optional<byte[]> getStartMenuLayoutXml() {
        return Optional.ofNullable(startMenuLayoutXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuLayoutXml} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allows admins to override the default Start layout and prevents the user from
     * changing it. The layout is modified by specifying an XML file based on a layout
     * modification schema. XML needs to be in Binary format.”</i>
     * 
     * @param startMenuLayoutXml
     *            new value of {@code startMenuLayoutXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuLayoutXml} field changed
     */
    public WindowsKioskMultipleApps withStartMenuLayoutXml(byte[] startMenuLayoutXml) {
        WindowsKioskMultipleApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskMultipleApps");
        _x.startMenuLayoutXml = startMenuLayoutXml;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskMultipleApps() {
        return new Builder();
    }

    public static final class Builder {
        private List<WindowsKioskAppBase> apps;
        private String appsNextLink;
        private Boolean showTaskBar;
        private Boolean allowAccessToDownloadsFolder;
        private Boolean disallowDesktopApps;
        private byte[] startMenuLayoutXml;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“These are the only Windows Store Apps that will be available to launch from the
         * Start menu. This collection can contain a maximum of 128 elements.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(List<WindowsKioskAppBase> apps) {
            this.apps = apps;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        /**
         * <i>“These are the only Windows Store Apps that will be available to launch from the
         * Start menu. This collection can contain a maximum of 128 elements.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(WindowsKioskAppBase... apps) {
            return apps(Arrays.asList(apps));
        }

        /**
         * <i>“These are the only Windows Store Apps that will be available to launch from the
         * Start menu. This collection can contain a maximum of 128 elements.”</i>
         * 
         * @param appsNextLink
         *            value of {@code apps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsNextLink(String appsNextLink) {
            this.appsNextLink = appsNextLink;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        /**
         * <i>“This setting allows the admin to specify whether the Task Bar is shown or not.”</i>
         * 
         * @param showTaskBar
         *            value of {@code showTaskBar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showTaskBar(Boolean showTaskBar) {
            this.showTaskBar = showTaskBar;
            this.changedFields = changedFields.add("showTaskBar");
            return this;
        }

        /**
         * <i>“This setting allows access to Downloads folder in file explorer.”</i>
         * 
         * @param allowAccessToDownloadsFolder
         *            value of {@code allowAccessToDownloadsFolder} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowAccessToDownloadsFolder(Boolean allowAccessToDownloadsFolder) {
            this.allowAccessToDownloadsFolder = allowAccessToDownloadsFolder;
            this.changedFields = changedFields.add("allowAccessToDownloadsFolder");
            return this;
        }

        /**
         * <i>“This setting indicates that desktop apps are allowed. Default to true.”</i>
         * 
         * @param disallowDesktopApps
         *            value of {@code disallowDesktopApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disallowDesktopApps(Boolean disallowDesktopApps) {
            this.disallowDesktopApps = disallowDesktopApps;
            this.changedFields = changedFields.add("disallowDesktopApps");
            return this;
        }

        /**
         * <i>“Allows admins to override the default Start layout and prevents the user from
         * changing it. The layout is modified by specifying an XML file based on a layout
         * modification schema. XML needs to be in Binary format.”</i>
         * 
         * @param startMenuLayoutXml
         *            value of {@code startMenuLayoutXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuLayoutXml(byte[] startMenuLayoutXml) {
            this.startMenuLayoutXml = startMenuLayoutXml;
            this.changedFields = changedFields.add("startMenuLayoutXml");
            return this;
        }

        public WindowsKioskMultipleApps build() {
            WindowsKioskMultipleApps _x = new WindowsKioskMultipleApps();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskMultipleApps";
            _x.apps = apps;
            _x.appsNextLink = appsNextLink;
            _x.showTaskBar = showTaskBar;
            _x.allowAccessToDownloadsFolder = allowAccessToDownloadsFolder;
            _x.disallowDesktopApps = disallowDesktopApps;
            _x.startMenuLayoutXml = startMenuLayoutXml;
            return _x;
        }
    }

    private WindowsKioskMultipleApps _copy() {
        WindowsKioskMultipleApps _x = new WindowsKioskMultipleApps();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.apps = apps;
        _x.showTaskBar = showTaskBar;
        _x.allowAccessToDownloadsFolder = allowAccessToDownloadsFolder;
        _x.disallowDesktopApps = disallowDesktopApps;
        _x.startMenuLayoutXml = startMenuLayoutXml;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskMultipleApps[");
        b.append("apps=");
        b.append(this.apps);
        b.append(", ");
        b.append("showTaskBar=");
        b.append(this.showTaskBar);
        b.append(", ");
        b.append("allowAccessToDownloadsFolder=");
        b.append(this.allowAccessToDownloadsFolder);
        b.append(", ");
        b.append("disallowDesktopApps=");
        b.append(this.disallowDesktopApps);
        b.append(", ");
        b.append("startMenuLayoutXml=");
        b.append(this.startMenuLayoutXml);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
