package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DayOfWeek;
import odata.msgraph.client.beta.enums.Windows10AppsUpdateRecurrence;


/**
 * <i>“Windows 10 force update schedule for Kiosk devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "startDateTime", 
    "recurrence", 
    "dayofWeek", 
    "dayofMonth", 
    "runImmediatelyIfAfterStartDateTime"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskForceUpdateSchedule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("recurrence")
    protected Windows10AppsUpdateRecurrence recurrence;

    @JsonProperty("dayofWeek")
    protected DayOfWeek dayofWeek;

    @JsonProperty("dayofMonth")
    protected Integer dayofMonth;

    @JsonProperty("runImmediatelyIfAfterStartDateTime")
    protected Boolean runImmediatelyIfAfterStartDateTime;

    protected WindowsKioskForceUpdateSchedule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskForceUpdateSchedule";
    }

    /**
     * <i>“The start time for the force restart.”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The start time for the force restart.”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public WindowsKioskForceUpdateSchedule withStartDateTime(OffsetDateTime startDateTime) {
        WindowsKioskForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskForceUpdateSchedule");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“Recurrence schedule.”</i>
     * 
     * @return property recurrence
     */
    @Property(name="recurrence")
    @JsonIgnore
    public Optional<Windows10AppsUpdateRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recurrence} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Recurrence schedule.”</i>
     * 
     * @param recurrence
     *            new value of {@code recurrence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recurrence} field changed
     */
    public WindowsKioskForceUpdateSchedule withRecurrence(Windows10AppsUpdateRecurrence recurrence) {
        WindowsKioskForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskForceUpdateSchedule");
        _x.recurrence = recurrence;
        return _x;
    }

    /**
     * <i>“Day of week.”</i>
     * 
     * @return property dayofWeek
     */
    @Property(name="dayofWeek")
    @JsonIgnore
    public Optional<DayOfWeek> getDayofWeek() {
        return Optional.ofNullable(dayofWeek);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dayofWeek} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Day of week.”</i>
     * 
     * @param dayofWeek
     *            new value of {@code dayofWeek} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dayofWeek} field changed
     */
    public WindowsKioskForceUpdateSchedule withDayofWeek(DayOfWeek dayofWeek) {
        WindowsKioskForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskForceUpdateSchedule");
        _x.dayofWeek = dayofWeek;
        return _x;
    }

    /**
     * <i>“Day of month. Valid values 1 to 31”</i>
     * 
     * @return property dayofMonth
     */
    @Property(name="dayofMonth")
    @JsonIgnore
    public Optional<Integer> getDayofMonth() {
        return Optional.ofNullable(dayofMonth);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dayofMonth} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Day of month. Valid values 1 to 31”</i>
     * 
     * @param dayofMonth
     *            new value of {@code dayofMonth} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dayofMonth} field changed
     */
    public WindowsKioskForceUpdateSchedule withDayofMonth(Integer dayofMonth) {
        WindowsKioskForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskForceUpdateSchedule");
        _x.dayofMonth = dayofMonth;
        return _x;
    }

    /**
     * <i>“If true, runs the task immediately if StartDateTime is in the past, else, runs
     * at the next recurrence.”</i>
     * 
     * @return property runImmediatelyIfAfterStartDateTime
     */
    @Property(name="runImmediatelyIfAfterStartDateTime")
    @JsonIgnore
    public Optional<Boolean> getRunImmediatelyIfAfterStartDateTime() {
        return Optional.ofNullable(runImmediatelyIfAfterStartDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * runImmediatelyIfAfterStartDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“If true, runs the task immediately if StartDateTime is in the past, else, runs
     * at the next recurrence.”</i>
     * 
     * @param runImmediatelyIfAfterStartDateTime
     *            new value of {@code runImmediatelyIfAfterStartDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runImmediatelyIfAfterStartDateTime} field changed
     */
    public WindowsKioskForceUpdateSchedule withRunImmediatelyIfAfterStartDateTime(Boolean runImmediatelyIfAfterStartDateTime) {
        WindowsKioskForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskForceUpdateSchedule");
        _x.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime startDateTime;
        private Windows10AppsUpdateRecurrence recurrence;
        private DayOfWeek dayofWeek;
        private Integer dayofMonth;
        private Boolean runImmediatelyIfAfterStartDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The start time for the force restart.”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Recurrence schedule.”</i>
         * 
         * @param recurrence
         *            value of {@code recurrence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recurrence(Windows10AppsUpdateRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        /**
         * <i>“Day of week.”</i>
         * 
         * @param dayofWeek
         *            value of {@code dayofWeek} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dayofWeek(DayOfWeek dayofWeek) {
            this.dayofWeek = dayofWeek;
            this.changedFields = changedFields.add("dayofWeek");
            return this;
        }

        /**
         * <i>“Day of month. Valid values 1 to 31”</i>
         * 
         * @param dayofMonth
         *            value of {@code dayofMonth} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dayofMonth(Integer dayofMonth) {
            this.dayofMonth = dayofMonth;
            this.changedFields = changedFields.add("dayofMonth");
            return this;
        }

        /**
         * <i>“If true, runs the task immediately if StartDateTime is in the past, else, runs
         * at the next recurrence.”</i>
         * 
         * @param runImmediatelyIfAfterStartDateTime
         *            value of {@code runImmediatelyIfAfterStartDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runImmediatelyIfAfterStartDateTime(Boolean runImmediatelyIfAfterStartDateTime) {
            this.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
            this.changedFields = changedFields.add("runImmediatelyIfAfterStartDateTime");
            return this;
        }

        public WindowsKioskForceUpdateSchedule build() {
            WindowsKioskForceUpdateSchedule _x = new WindowsKioskForceUpdateSchedule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskForceUpdateSchedule";
            _x.startDateTime = startDateTime;
            _x.recurrence = recurrence;
            _x.dayofWeek = dayofWeek;
            _x.dayofMonth = dayofMonth;
            _x.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
            return _x;
        }
    }

    private WindowsKioskForceUpdateSchedule _copy() {
        WindowsKioskForceUpdateSchedule _x = new WindowsKioskForceUpdateSchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startDateTime = startDateTime;
        _x.recurrence = recurrence;
        _x.dayofWeek = dayofWeek;
        _x.dayofMonth = dayofMonth;
        _x.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskForceUpdateSchedule[");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("dayofWeek=");
        b.append(this.dayofWeek);
        b.append(", ");
        b.append("dayofMonth=");
        b.append(this.dayofMonth);
        b.append(", ");
        b.append("runImmediatelyIfAfterStartDateTime=");
        b.append(this.runImmediatelyIfAfterStartDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
