package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The class used to identify an AzureAD user account for the kiosk configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskAzureADUser extends WindowsKioskUser implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected WindowsKioskAzureADUser() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskAzureADUser";
    }

    /**
     * <i>“The ID of the AzureAD user that will be locked to this kiosk configuration”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The ID of the AzureAD user that will be locked to this kiosk configuration”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public WindowsKioskAzureADUser withUserId(String userId) {
        WindowsKioskAzureADUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAzureADUser");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“The user accounts that will be locked to this kiosk configuration”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user accounts that will be locked to this kiosk configuration”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public WindowsKioskAzureADUser withUserPrincipalName(String userPrincipalName) {
        WindowsKioskAzureADUser _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAzureADUser");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskAzureADUser() {
        return new Builder();
    }

    public static final class Builder {
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The ID of the AzureAD user that will be locked to this kiosk configuration”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“The user accounts that will be locked to this kiosk configuration”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public WindowsKioskAzureADUser build() {
            WindowsKioskAzureADUser _x = new WindowsKioskAzureADUser();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskAzureADUser";
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private WindowsKioskAzureADUser _copy() {
        WindowsKioskAzureADUser _x = new WindowsKioskAzureADUser();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskAzureADUser[");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
