package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The class used to identify an AzureAD group for the kiosk configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "groupId"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskAzureADGroup extends WindowsKioskUser implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("groupId")
    protected String groupId;

    protected WindowsKioskAzureADGroup() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskAzureADGroup";
    }

    /**
     * <i>“The display name of the AzureAD group that will be locked to this kiosk
     * configuration”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of the AzureAD group that will be locked to this kiosk
     * configuration”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsKioskAzureADGroup withDisplayName(String displayName) {
        WindowsKioskAzureADGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAzureADGroup");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The ID of the AzureAD group that will be locked to this kiosk configuration”</i>
     * 
     * @return property groupId
     */
    @Property(name="groupId")
    @JsonIgnore
    public Optional<String> getGroupId() {
        return Optional.ofNullable(groupId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The ID of the AzureAD group that will be locked to this kiosk configuration”</i>
     * 
     * @param groupId
     *            new value of {@code groupId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupId} field changed
     */
    public WindowsKioskAzureADGroup withGroupId(String groupId) {
        WindowsKioskAzureADGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAzureADGroup");
        _x.groupId = groupId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskAzureADGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String groupId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The display name of the AzureAD group that will be locked to this kiosk
         * configuration”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The ID of the AzureAD group that will be locked to this kiosk configuration”</i>
         * 
         * @param groupId
         *            value of {@code groupId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.changedFields = changedFields.add("groupId");
            return this;
        }

        public WindowsKioskAzureADGroup build() {
            WindowsKioskAzureADGroup _x = new WindowsKioskAzureADGroup();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskAzureADGroup";
            _x.displayName = displayName;
            _x.groupId = groupId;
            return _x;
        }
    }

    private WindowsKioskAzureADGroup _copy() {
        WindowsKioskAzureADGroup _x = new WindowsKioskAzureADGroup();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.groupId = groupId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskAzureADGroup[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("groupId=");
        b.append(this.groupId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
