package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsAppStartLayoutTileSize;
import odata.msgraph.client.beta.enums.WindowsKioskAppType;


/**
 * <i>“The base class for a type of apps”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "startLayoutTileSize", 
    "name", 
    "appType", 
    "autoLaunch"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskAppBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("startLayoutTileSize")
    protected WindowsAppStartLayoutTileSize startLayoutTileSize;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("appType")
    protected WindowsKioskAppType appType;

    @JsonProperty("autoLaunch")
    protected Boolean autoLaunch;

    protected WindowsKioskAppBase() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskAppBase";
    }

    /**
     * <i>“The app tile size for the start layout”</i>
     * 
     * @return property startLayoutTileSize
     */
    @Property(name="startLayoutTileSize")
    @JsonIgnore
    public Optional<WindowsAppStartLayoutTileSize> getStartLayoutTileSize() {
        return Optional.ofNullable(startLayoutTileSize);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startLayoutTileSize} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The app tile size for the start layout”</i>
     * 
     * @param startLayoutTileSize
     *            new value of {@code startLayoutTileSize} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startLayoutTileSize} field changed
     */
    public WindowsKioskAppBase withStartLayoutTileSize(WindowsAppStartLayoutTileSize startLayoutTileSize) {
        WindowsKioskAppBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAppBase");
        _x.startLayoutTileSize = startLayoutTileSize;
        return _x;
    }

    /**
     * <i>“Represents the friendly name of an app”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Represents the friendly name of an app”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public WindowsKioskAppBase withName(String name) {
        WindowsKioskAppBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAppBase");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“The app type”</i>
     * 
     * @return property appType
     */
    @Property(name="appType")
    @JsonIgnore
    public Optional<WindowsKioskAppType> getAppType() {
        return Optional.ofNullable(appType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app type”</i>
     * 
     * @param appType
     *            new value of {@code appType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appType} field changed
     */
    public WindowsKioskAppBase withAppType(WindowsKioskAppType appType) {
        WindowsKioskAppBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAppBase");
        _x.appType = appType;
        return _x;
    }

    /**
     * <i>“Allow the app to be auto-launched in multi-app kiosk mode”</i>
     * 
     * @return property autoLaunch
     */
    @Property(name="autoLaunch")
    @JsonIgnore
    public Optional<Boolean> getAutoLaunch() {
        return Optional.ofNullable(autoLaunch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code autoLaunch} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Allow the app to be auto-launched in multi-app kiosk mode”</i>
     * 
     * @param autoLaunch
     *            new value of {@code autoLaunch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoLaunch} field changed
     */
    public WindowsKioskAppBase withAutoLaunch(Boolean autoLaunch) {
        WindowsKioskAppBase _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskAppBase");
        _x.autoLaunch = autoLaunch;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private WindowsKioskAppBase _copy() {
        WindowsKioskAppBase _x = new WindowsKioskAppBase();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startLayoutTileSize = startLayoutTileSize;
        _x.name = name;
        _x.appType = appType;
        _x.autoLaunch = autoLaunch;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskAppBase[");
        b.append("startLayoutTileSize=");
        b.append(this.startLayoutTileSize);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("appType=");
        b.append(this.appType);
        b.append(", ");
        b.append("autoLaunch=");
        b.append(this.autoLaunch);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
