package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The class used to identify an Azure Directory group for the kiosk configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "groupName"})
@JsonInclude(Include.NON_NULL)
public class WindowsKioskActiveDirectoryGroup extends WindowsKioskUser implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("groupName")
    protected String groupName;

    protected WindowsKioskActiveDirectoryGroup() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsKioskActiveDirectoryGroup";
    }

    /**
     * <i>“The name of the AD group that will be locked to this kiosk configuration”</i>
     * 
     * @return property groupName
     */
    @Property(name="groupName")
    @JsonIgnore
    public Optional<String> getGroupName() {
        return Optional.ofNullable(groupName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the AD group that will be locked to this kiosk configuration”</i>
     * 
     * @param groupName
     *            new value of {@code groupName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupName} field changed
     */
    public WindowsKioskActiveDirectoryGroup withGroupName(String groupName) {
        WindowsKioskActiveDirectoryGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsKioskActiveDirectoryGroup");
        _x.groupName = groupName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsKioskActiveDirectoryGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String groupName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The name of the AD group that will be locked to this kiosk configuration”</i>
         * 
         * @param groupName
         *            value of {@code groupName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupName(String groupName) {
            this.groupName = groupName;
            this.changedFields = changedFields.add("groupName");
            return this;
        }

        public WindowsKioskActiveDirectoryGroup build() {
            WindowsKioskActiveDirectoryGroup _x = new WindowsKioskActiveDirectoryGroup();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsKioskActiveDirectoryGroup";
            _x.groupName = groupName;
            return _x;
        }
    }

    private WindowsKioskActiveDirectoryGroup _copy() {
        WindowsKioskActiveDirectoryGroup _x = new WindowsKioskActiveDirectoryGroup();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.groupName = groupName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsKioskActiveDirectoryGroup[");
        b.append("groupName=");
        b.append(this.groupName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
