package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;


/**
 * <i>“Store App for Windows information protection”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionStoreApp extends WindowsInformationProtectionApp implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    protected WindowsInformationProtectionStoreApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionStoreApp";
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionStoreApp() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String description;
        private String publisherName;
        private String productName;
        private Boolean denied;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.changedFields = changedFields.add("publisherName");
            return this;
        }

        public Builder productName(String productName) {
            this.productName = productName;
            this.changedFields = changedFields.add("productName");
            return this;
        }

        public Builder denied(Boolean denied) {
            this.denied = denied;
            this.changedFields = changedFields.add("denied");
            return this;
        }

        public WindowsInformationProtectionStoreApp build() {
            WindowsInformationProtectionStoreApp _x = new WindowsInformationProtectionStoreApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsInformationProtectionStoreApp";
            _x.displayName = displayName;
            _x.description = description;
            _x.publisherName = publisherName;
            _x.productName = productName;
            _x.denied = denied;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionStoreApp[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisherName=");
        b.append(this.publisherName);
        b.append(", ");
        b.append("productName=");
        b.append(this.productName);
        b.append(", ");
        b.append("denied=");
        b.append(this.denied);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
