package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Windows Information Protection Proxied Domain Collection”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "proxiedDomains"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionProxiedDomainCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("proxiedDomains")
    protected List<ProxiedDomain> proxiedDomains;

    @JsonProperty("proxiedDomains@nextLink")
    protected String proxiedDomainsNextLink;

    protected WindowsInformationProtectionProxiedDomainCollection() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionProxiedDomainCollection";
    }

    /**
     * <i>“Display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsInformationProtectionProxiedDomainCollection withDisplayName(String displayName) {
        WindowsInformationProtectionProxiedDomainCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionProxiedDomainCollection");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Collection of proxied domains”</i>
     * 
     * @return property proxiedDomains
     */
    @Property(name="proxiedDomains")
    @JsonIgnore
    public CollectionPage<ProxiedDomain> getProxiedDomains() {
        return new CollectionPage<ProxiedDomain>(contextPath, ProxiedDomain.class, proxiedDomains, Optional.ofNullable(proxiedDomainsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of proxied domains”</i>
     * 
     * @return property proxiedDomains
     */
    @Property(name="proxiedDomains")
    @JsonIgnore
    public CollectionPage<ProxiedDomain> getProxiedDomains(HttpRequestOptions options) {
        return new CollectionPage<ProxiedDomain>(contextPath, ProxiedDomain.class, proxiedDomains, Optional.ofNullable(proxiedDomainsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private List<ProxiedDomain> proxiedDomains;
        private String proxiedDomainsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Collection of proxied domains”</i>
         * 
         * @param proxiedDomains
         *            value of {@code proxiedDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxiedDomains(List<ProxiedDomain> proxiedDomains) {
            this.proxiedDomains = proxiedDomains;
            this.changedFields = changedFields.add("proxiedDomains");
            return this;
        }

        /**
         * <i>“Collection of proxied domains”</i>
         * 
         * @param proxiedDomains
         *            value of {@code proxiedDomains} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxiedDomains(ProxiedDomain... proxiedDomains) {
            return proxiedDomains(Arrays.asList(proxiedDomains));
        }

        /**
         * <i>“Collection of proxied domains”</i>
         * 
         * @param proxiedDomainsNextLink
         *            value of {@code proxiedDomains@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxiedDomainsNextLink(String proxiedDomainsNextLink) {
            this.proxiedDomainsNextLink = proxiedDomainsNextLink;
            this.changedFields = changedFields.add("proxiedDomains");
            return this;
        }

        public WindowsInformationProtectionProxiedDomainCollection build() {
            WindowsInformationProtectionProxiedDomainCollection _x = new WindowsInformationProtectionProxiedDomainCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsInformationProtectionProxiedDomainCollection";
            _x.displayName = displayName;
            _x.proxiedDomains = proxiedDomains;
            _x.proxiedDomainsNextLink = proxiedDomainsNextLink;
            return _x;
        }
    }

    private WindowsInformationProtectionProxiedDomainCollection _copy() {
        WindowsInformationProtectionProxiedDomainCollection _x = new WindowsInformationProtectionProxiedDomainCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.proxiedDomains = proxiedDomains;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionProxiedDomainCollection[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("proxiedDomains=");
        b.append(this.proxiedDomains);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
