package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Desktop App for Windows information protection”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "binaryName", 
    "binaryVersionLow", 
    "binaryVersionHigh"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionDesktopApp extends WindowsInformationProtectionApp implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("binaryName")
    protected String binaryName;

    @JsonProperty("binaryVersionLow")
    protected String binaryVersionLow;

    @JsonProperty("binaryVersionHigh")
    protected String binaryVersionHigh;

    protected WindowsInformationProtectionDesktopApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionDesktopApp";
    }

    /**
     * <i>“The binary name.”</i>
     * 
     * @return property binaryName
     */
    @Property(name="binaryName")
    @JsonIgnore
    public Optional<String> getBinaryName() {
        return Optional.ofNullable(binaryName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code binaryName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The binary name.”</i>
     * 
     * @param binaryName
     *            new value of {@code binaryName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code binaryName} field changed
     */
    public WindowsInformationProtectionDesktopApp withBinaryName(String binaryName) {
        WindowsInformationProtectionDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDesktopApp");
        _x.binaryName = binaryName;
        return _x;
    }

    /**
     * <i>“The lower binary version.”</i>
     * 
     * @return property binaryVersionLow
     */
    @Property(name="binaryVersionLow")
    @JsonIgnore
    public Optional<String> getBinaryVersionLow() {
        return Optional.ofNullable(binaryVersionLow);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code binaryVersionLow}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The lower binary version.”</i>
     * 
     * @param binaryVersionLow
     *            new value of {@code binaryVersionLow} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code binaryVersionLow} field changed
     */
    public WindowsInformationProtectionDesktopApp withBinaryVersionLow(String binaryVersionLow) {
        WindowsInformationProtectionDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDesktopApp");
        _x.binaryVersionLow = binaryVersionLow;
        return _x;
    }

    /**
     * <i>“The high binary version.”</i>
     * 
     * @return property binaryVersionHigh
     */
    @Property(name="binaryVersionHigh")
    @JsonIgnore
    public Optional<String> getBinaryVersionHigh() {
        return Optional.ofNullable(binaryVersionHigh);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code binaryVersionHigh
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The high binary version.”</i>
     * 
     * @param binaryVersionHigh
     *            new value of {@code binaryVersionHigh} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code binaryVersionHigh} field changed
     */
    public WindowsInformationProtectionDesktopApp withBinaryVersionHigh(String binaryVersionHigh) {
        WindowsInformationProtectionDesktopApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDesktopApp");
        _x.binaryVersionHigh = binaryVersionHigh;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionDesktopApp() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String description;
        private String publisherName;
        private String productName;
        private Boolean denied;
        private String binaryName;
        private String binaryVersionLow;
        private String binaryVersionHigh;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.changedFields = changedFields.add("publisherName");
            return this;
        }

        public Builder productName(String productName) {
            this.productName = productName;
            this.changedFields = changedFields.add("productName");
            return this;
        }

        public Builder denied(Boolean denied) {
            this.denied = denied;
            this.changedFields = changedFields.add("denied");
            return this;
        }

        /**
         * <i>“The binary name.”</i>
         * 
         * @param binaryName
         *            value of {@code binaryName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder binaryName(String binaryName) {
            this.binaryName = binaryName;
            this.changedFields = changedFields.add("binaryName");
            return this;
        }

        /**
         * <i>“The lower binary version.”</i>
         * 
         * @param binaryVersionLow
         *            value of {@code binaryVersionLow} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder binaryVersionLow(String binaryVersionLow) {
            this.binaryVersionLow = binaryVersionLow;
            this.changedFields = changedFields.add("binaryVersionLow");
            return this;
        }

        /**
         * <i>“The high binary version.”</i>
         * 
         * @param binaryVersionHigh
         *            value of {@code binaryVersionHigh} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder binaryVersionHigh(String binaryVersionHigh) {
            this.binaryVersionHigh = binaryVersionHigh;
            this.changedFields = changedFields.add("binaryVersionHigh");
            return this;
        }

        public WindowsInformationProtectionDesktopApp build() {
            WindowsInformationProtectionDesktopApp _x = new WindowsInformationProtectionDesktopApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsInformationProtectionDesktopApp";
            _x.displayName = displayName;
            _x.description = description;
            _x.publisherName = publisherName;
            _x.productName = productName;
            _x.denied = denied;
            _x.binaryName = binaryName;
            _x.binaryVersionLow = binaryVersionLow;
            _x.binaryVersionHigh = binaryVersionHigh;
            return _x;
        }
    }

    private WindowsInformationProtectionDesktopApp _copy() {
        WindowsInformationProtectionDesktopApp _x = new WindowsInformationProtectionDesktopApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisherName = publisherName;
        _x.productName = productName;
        _x.denied = denied;
        _x.binaryName = binaryName;
        _x.binaryVersionLow = binaryVersionLow;
        _x.binaryVersionHigh = binaryVersionHigh;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionDesktopApp[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisherName=");
        b.append(this.publisherName);
        b.append(", ");
        b.append("productName=");
        b.append(this.productName);
        b.append(", ");
        b.append("denied=");
        b.append(this.denied);
        b.append(", ");
        b.append("binaryName=");
        b.append(this.binaryName);
        b.append(", ");
        b.append("binaryVersionLow=");
        b.append(this.binaryVersionLow);
        b.append(", ");
        b.append("binaryVersionHigh=");
        b.append(this.binaryVersionHigh);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
