package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Windows Information Protection DataRecoveryCertificate”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "subjectName", 
    "description", 
    "expirationDateTime", 
    "certificate"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionDataRecoveryCertificate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("subjectName")
    protected String subjectName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("certificate")
    protected byte[] certificate;

    protected WindowsInformationProtectionDataRecoveryCertificate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionDataRecoveryCertificate";
    }

    /**
     * <i>“Data recovery Certificate subject name”</i>
     * 
     * @return property subjectName
     */
    @Property(name="subjectName")
    @JsonIgnore
    public Optional<String> getSubjectName() {
        return Optional.ofNullable(subjectName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subjectName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Data recovery Certificate subject name”</i>
     * 
     * @param subjectName
     *            new value of {@code subjectName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectName} field changed
     */
    public WindowsInformationProtectionDataRecoveryCertificate withSubjectName(String subjectName) {
        WindowsInformationProtectionDataRecoveryCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDataRecoveryCertificate");
        _x.subjectName = subjectName;
        return _x;
    }

    /**
     * <i>“Data recovery Certificate description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Data recovery Certificate description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public WindowsInformationProtectionDataRecoveryCertificate withDescription(String description) {
        WindowsInformationProtectionDataRecoveryCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDataRecoveryCertificate");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Data recovery Certificate expiration datetime”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Data recovery Certificate expiration datetime”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public WindowsInformationProtectionDataRecoveryCertificate withExpirationDateTime(OffsetDateTime expirationDateTime) {
        WindowsInformationProtectionDataRecoveryCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDataRecoveryCertificate");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“Data recovery Certificate”</i>
     * 
     * @return property certificate
     */
    @Property(name="certificate")
    @JsonIgnore
    public Optional<byte[]> getCertificate() {
        return Optional.ofNullable(certificate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certificate}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Data recovery Certificate”</i>
     * 
     * @param certificate
     *            new value of {@code certificate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificate} field changed
     */
    public WindowsInformationProtectionDataRecoveryCertificate withCertificate(byte[] certificate) {
        WindowsInformationProtectionDataRecoveryCertificate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionDataRecoveryCertificate");
        _x.certificate = certificate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String subjectName;
        private String description;
        private OffsetDateTime expirationDateTime;
        private byte[] certificate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Data recovery Certificate subject name”</i>
         * 
         * @param subjectName
         *            value of {@code subjectName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectName(String subjectName) {
            this.subjectName = subjectName;
            this.changedFields = changedFields.add("subjectName");
            return this;
        }

        /**
         * <i>“Data recovery Certificate description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Data recovery Certificate expiration datetime”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“Data recovery Certificate”</i>
         * 
         * @param certificate
         *            value of {@code certificate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificate(byte[] certificate) {
            this.certificate = certificate;
            this.changedFields = changedFields.add("certificate");
            return this;
        }

        public WindowsInformationProtectionDataRecoveryCertificate build() {
            WindowsInformationProtectionDataRecoveryCertificate _x = new WindowsInformationProtectionDataRecoveryCertificate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsInformationProtectionDataRecoveryCertificate";
            _x.subjectName = subjectName;
            _x.description = description;
            _x.expirationDateTime = expirationDateTime;
            _x.certificate = certificate;
            return _x;
        }
    }

    private WindowsInformationProtectionDataRecoveryCertificate _copy() {
        WindowsInformationProtectionDataRecoveryCertificate _x = new WindowsInformationProtectionDataRecoveryCertificate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.subjectName = subjectName;
        _x.description = description;
        _x.expirationDateTime = expirationDateTime;
        _x.certificate = certificate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionDataRecoveryCertificate[");
        b.append("subjectName=");
        b.append(this.subjectName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("certificate=");
        b.append(this.certificate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
