package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class WindowsDeviceAzureADAccount extends WindowsDeviceAccount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected WindowsDeviceAzureADAccount() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDeviceAzureADAccount";
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public WindowsDeviceAzureADAccount withUserPrincipalName(String userPrincipalName) {
        WindowsDeviceAzureADAccount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeviceAzureADAccount");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDeviceAzureADAccount() {
        return new Builder();
    }

    public static final class Builder {
        private String password;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder password(String password) {
            this.password = password;
            this.changedFields = changedFields.add("password");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public WindowsDeviceAzureADAccount build() {
            WindowsDeviceAzureADAccount _x = new WindowsDeviceAzureADAccount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDeviceAzureADAccount";
            _x.password = password;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private WindowsDeviceAzureADAccount _copy() {
        WindowsDeviceAzureADAccount _x = new WindowsDeviceAzureADAccount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.password = password;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDeviceAzureADAccount[");
        b.append("password=");
        b.append(this.password);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
