package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Windows Defender last scan result”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "scanType"})
@JsonInclude(Include.NON_NULL)
public class WindowsDefenderScanActionResult extends DeviceActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("scanType")
    protected String scanType;

    protected WindowsDefenderScanActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDefenderScanActionResult";
    }

    /**
     * <i>“Scan type either full scan or quick scan”</i>
     * 
     * @return property scanType
     */
    @Property(name="scanType")
    @JsonIgnore
    public Optional<String> getScanType() {
        return Optional.ofNullable(scanType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scanType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Scan type either full scan or quick scan”</i>
     * 
     * @param scanType
     *            new value of {@code scanType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scanType} field changed
     */
    public WindowsDefenderScanActionResult withScanType(String scanType) {
        WindowsDefenderScanActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDefenderScanActionResult");
        _x.scanType = scanType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDefenderScanActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private String scanType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“Scan type either full scan or quick scan”</i>
         * 
         * @param scanType
         *            value of {@code scanType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scanType(String scanType) {
            this.scanType = scanType;
            this.changedFields = changedFields.add("scanType");
            return this;
        }

        public WindowsDefenderScanActionResult build() {
            WindowsDefenderScanActionResult _x = new WindowsDefenderScanActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windowsDefenderScanActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.scanType = scanType;
            return _x;
        }
    }

    private WindowsDefenderScanActionResult _copy() {
        WindowsDefenderScanActionResult _x = new WindowsDefenderScanActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.scanType = scanType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDefenderScanActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("scanType=");
        b.append(this.scanType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
