package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Network Proxy Server Policy.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "exceptions", 
    "useForLocalAddresses"})
@JsonInclude(Include.NON_NULL)
public class Windows10NetworkProxyServer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("address")
    protected String address;

    @JsonProperty("exceptions")
    protected List<String> exceptions;

    @JsonProperty("exceptions@nextLink")
    protected String exceptionsNextLink;

    @JsonProperty("useForLocalAddresses")
    protected Boolean useForLocalAddresses;

    protected Windows10NetworkProxyServer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10NetworkProxyServer";
    }

    /**
     * <i>“Address to the proxy server. Specify an address in the format &amp;lt;server&amp;gt;[“:”&amp;lt;port&amp;gt;
     * ]”</i>
     * 
     * @return property address
     */
    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code address} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Address to the proxy server. Specify an address in the format &amp;lt;server&amp;gt;[“:”&amp;lt;port&amp;gt;
     * ]”</i>
     * 
     * @param address
     *            new value of {@code address} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code address} field changed
     */
    public Windows10NetworkProxyServer withAddress(String address) {
        Windows10NetworkProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10NetworkProxyServer");
        _x.address = address;
        return _x;
    }

    /**
     * <i>“Addresses that should not use the proxy server. The system will not use the
     * proxy server for addresses beginning with what is specified in this node.”</i>
     * 
     * @return property exceptions
     */
    @Property(name="exceptions")
    @JsonIgnore
    public CollectionPage<String> getExceptions() {
        return new CollectionPage<String>(contextPath, String.class, exceptions, Optional.ofNullable(exceptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Addresses that should not use the proxy server. The system will not use the
     * proxy server for addresses beginning with what is specified in this node.”</i>
     * 
     * @return property exceptions
     */
    @Property(name="exceptions")
    @JsonIgnore
    public CollectionPage<String> getExceptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, exceptions, Optional.ofNullable(exceptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Specifies whether the proxy server should be used for local (intranet) addresses
     * .”</i>
     * 
     * @return property useForLocalAddresses
     */
    @Property(name="useForLocalAddresses")
    @JsonIgnore
    public Optional<Boolean> getUseForLocalAddresses() {
        return Optional.ofNullable(useForLocalAddresses);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * useForLocalAddresses} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies whether the proxy server should be used for local (intranet) addresses
     * .”</i>
     * 
     * @param useForLocalAddresses
     *            new value of {@code useForLocalAddresses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useForLocalAddresses} field changed
     */
    public Windows10NetworkProxyServer withUseForLocalAddresses(Boolean useForLocalAddresses) {
        Windows10NetworkProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10NetworkProxyServer");
        _x.useForLocalAddresses = useForLocalAddresses;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String address;
        private List<String> exceptions;
        private String exceptionsNextLink;
        private Boolean useForLocalAddresses;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Address to the proxy server. Specify an address in the format &amp;lt;server&amp;gt;[“:”&amp;lt;port&amp;gt;
         * ]”</i>
         * 
         * @param address
         *            value of {@code address} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        /**
         * <i>“Addresses that should not use the proxy server. The system will not use the
         * proxy server for addresses beginning with what is specified in this node.”</i>
         * 
         * @param exceptions
         *            value of {@code exceptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exceptions(List<String> exceptions) {
            this.exceptions = exceptions;
            this.changedFields = changedFields.add("exceptions");
            return this;
        }

        /**
         * <i>“Addresses that should not use the proxy server. The system will not use the
         * proxy server for addresses beginning with what is specified in this node.”</i>
         * 
         * @param exceptions
         *            value of {@code exceptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exceptions(String... exceptions) {
            return exceptions(Arrays.asList(exceptions));
        }

        /**
         * <i>“Addresses that should not use the proxy server. The system will not use the
         * proxy server for addresses beginning with what is specified in this node.”</i>
         * 
         * @param exceptionsNextLink
         *            value of {@code exceptions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exceptionsNextLink(String exceptionsNextLink) {
            this.exceptionsNextLink = exceptionsNextLink;
            this.changedFields = changedFields.add("exceptions");
            return this;
        }

        /**
         * <i>“Specifies whether the proxy server should be used for local (intranet) addresses
         * .”</i>
         * 
         * @param useForLocalAddresses
         *            value of {@code useForLocalAddresses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useForLocalAddresses(Boolean useForLocalAddresses) {
            this.useForLocalAddresses = useForLocalAddresses;
            this.changedFields = changedFields.add("useForLocalAddresses");
            return this;
        }

        public Windows10NetworkProxyServer build() {
            Windows10NetworkProxyServer _x = new Windows10NetworkProxyServer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10NetworkProxyServer";
            _x.address = address;
            _x.exceptions = exceptions;
            _x.exceptionsNextLink = exceptionsNextLink;
            _x.useForLocalAddresses = useForLocalAddresses;
            return _x;
        }
    }

    private Windows10NetworkProxyServer _copy() {
        Windows10NetworkProxyServer _x = new Windows10NetworkProxyServer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.address = address;
        _x.exceptions = exceptions;
        _x.useForLocalAddresses = useForLocalAddresses;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10NetworkProxyServer[");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("exceptions=");
        b.append(this.exceptions);
        b.append(", ");
        b.append("useForLocalAddresses=");
        b.append(this.useForLocalAddresses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
