package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.Windows10AppType;


/**
 * <i>“Windows 10 Associated Application definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appType", 
    "identifier"})
@JsonInclude(Include.NON_NULL)
public class Windows10AssociatedApps implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appType")
    protected Windows10AppType appType;

    @JsonProperty("identifier")
    protected String identifier;

    protected Windows10AssociatedApps() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10AssociatedApps";
    }

    /**
     * <i>“Application type.”</i>
     * 
     * @return property appType
     */
    @Property(name="appType")
    @JsonIgnore
    public Optional<Windows10AppType> getAppType() {
        return Optional.ofNullable(appType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Application type.”</i>
     * 
     * @param appType
     *            new value of {@code appType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appType} field changed
     */
    public Windows10AssociatedApps withAppType(Windows10AppType appType) {
        Windows10AssociatedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10AssociatedApps");
        _x.appType = appType;
        return _x;
    }

    /**
     * <i>“Identifier.”</i>
     * 
     * @return property identifier
     */
    @Property(name="identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identifier} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier.”</i>
     * 
     * @param identifier
     *            new value of {@code identifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identifier} field changed
     */
    public Windows10AssociatedApps withIdentifier(String identifier) {
        Windows10AssociatedApps _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10AssociatedApps");
        _x.identifier = identifier;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Windows10AppType appType;
        private String identifier;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Application type.”</i>
         * 
         * @param appType
         *            value of {@code appType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appType(Windows10AppType appType) {
            this.appType = appType;
            this.changedFields = changedFields.add("appType");
            return this;
        }

        /**
         * <i>“Identifier.”</i>
         * 
         * @param identifier
         *            value of {@code identifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("identifier");
            return this;
        }

        public Windows10AssociatedApps build() {
            Windows10AssociatedApps _x = new Windows10AssociatedApps();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10AssociatedApps";
            _x.appType = appType;
            _x.identifier = identifier;
            return _x;
        }
    }

    private Windows10AssociatedApps _copy() {
        Windows10AssociatedApps _x = new Windows10AssociatedApps();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appType = appType;
        _x.identifier = identifier;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10AssociatedApps[");
        b.append("appType=");
        b.append(this.appType);
        b.append(", ");
        b.append("identifier=");
        b.append(this.identifier);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
