package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Windows10AppsUpdateRecurrence;


/**
 * <i>“Windows 10 force update schedule for Apps”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "startDateTime", 
    "recurrence", 
    "runImmediatelyIfAfterStartDateTime"})
@JsonInclude(Include.NON_NULL)
public class Windows10AppsForceUpdateSchedule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("recurrence")
    protected Windows10AppsUpdateRecurrence recurrence;

    @JsonProperty("runImmediatelyIfAfterStartDateTime")
    protected Boolean runImmediatelyIfAfterStartDateTime;

    protected Windows10AppsForceUpdateSchedule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10AppsForceUpdateSchedule";
    }

    /**
     * <i>“The start time for the force restart.”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The start time for the force restart.”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public Windows10AppsForceUpdateSchedule withStartDateTime(OffsetDateTime startDateTime) {
        Windows10AppsForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10AppsForceUpdateSchedule");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“Recurrence schedule.”</i>
     * 
     * @return property recurrence
     */
    @Property(name="recurrence")
    @JsonIgnore
    public Optional<Windows10AppsUpdateRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recurrence} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Recurrence schedule.”</i>
     * 
     * @param recurrence
     *            new value of {@code recurrence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recurrence} field changed
     */
    public Windows10AppsForceUpdateSchedule withRecurrence(Windows10AppsUpdateRecurrence recurrence) {
        Windows10AppsForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10AppsForceUpdateSchedule");
        _x.recurrence = recurrence;
        return _x;
    }

    /**
     * <i>“If true, runs the task immediately if StartDateTime is in the past, else, runs
     * at the next recurrence.”</i>
     * 
     * @return property runImmediatelyIfAfterStartDateTime
     */
    @Property(name="runImmediatelyIfAfterStartDateTime")
    @JsonIgnore
    public Optional<Boolean> getRunImmediatelyIfAfterStartDateTime() {
        return Optional.ofNullable(runImmediatelyIfAfterStartDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * runImmediatelyIfAfterStartDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“If true, runs the task immediately if StartDateTime is in the past, else, runs
     * at the next recurrence.”</i>
     * 
     * @param runImmediatelyIfAfterStartDateTime
     *            new value of {@code runImmediatelyIfAfterStartDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runImmediatelyIfAfterStartDateTime} field changed
     */
    public Windows10AppsForceUpdateSchedule withRunImmediatelyIfAfterStartDateTime(Boolean runImmediatelyIfAfterStartDateTime) {
        Windows10AppsForceUpdateSchedule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10AppsForceUpdateSchedule");
        _x.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime startDateTime;
        private Windows10AppsUpdateRecurrence recurrence;
        private Boolean runImmediatelyIfAfterStartDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The start time for the force restart.”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Recurrence schedule.”</i>
         * 
         * @param recurrence
         *            value of {@code recurrence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recurrence(Windows10AppsUpdateRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        /**
         * <i>“If true, runs the task immediately if StartDateTime is in the past, else, runs
         * at the next recurrence.”</i>
         * 
         * @param runImmediatelyIfAfterStartDateTime
         *            value of {@code runImmediatelyIfAfterStartDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runImmediatelyIfAfterStartDateTime(Boolean runImmediatelyIfAfterStartDateTime) {
            this.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
            this.changedFields = changedFields.add("runImmediatelyIfAfterStartDateTime");
            return this;
        }

        public Windows10AppsForceUpdateSchedule build() {
            Windows10AppsForceUpdateSchedule _x = new Windows10AppsForceUpdateSchedule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.windows10AppsForceUpdateSchedule";
            _x.startDateTime = startDateTime;
            _x.recurrence = recurrence;
            _x.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
            return _x;
        }
    }

    private Windows10AppsForceUpdateSchedule _copy() {
        Windows10AppsForceUpdateSchedule _x = new Windows10AppsForceUpdateSchedule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startDateTime = startDateTime;
        _x.recurrence = recurrence;
        _x.runImmediatelyIfAfterStartDateTime = runImmediatelyIfAfterStartDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10AppsForceUpdateSchedule[");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("runImmediatelyIfAfterStartDateTime=");
        b.append(this.runImmediatelyIfAfterStartDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
