package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppReturnCodeType;


/**
 * <i>“Contains return code properties for a Win32 App”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "returnCode", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppReturnCode implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("returnCode")
    protected Integer returnCode;

    @JsonProperty("type")
    protected Win32LobAppReturnCodeType type;

    protected Win32LobAppReturnCode() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppReturnCode";
    }

    /**
     * <i>“Return code.”</i>
     * 
     * @return property returnCode
     */
    @Property(name="returnCode")
    @JsonIgnore
    public Optional<Integer> getReturnCode() {
        return Optional.ofNullable(returnCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code returnCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Return code.”</i>
     * 
     * @param returnCode
     *            new value of {@code returnCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code returnCode} field changed
     */
    public Win32LobAppReturnCode withReturnCode(Integer returnCode) {
        Win32LobAppReturnCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppReturnCode");
        _x.returnCode = returnCode;
        return _x;
    }

    /**
     * <i>“The type of return code.”</i>
     * 
     * @return property type
     */
    @Property(name="type")
    @JsonIgnore
    public Optional<Win32LobAppReturnCodeType> getType() {
        return Optional.ofNullable(type);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code type} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The type of return code.”</i>
     * 
     * @param type
     *            new value of {@code type} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code type} field changed
     */
    public Win32LobAppReturnCode withType(Win32LobAppReturnCodeType type) {
        Win32LobAppReturnCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppReturnCode");
        _x.type = type;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer returnCode;
        private Win32LobAppReturnCodeType type;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Return code.”</i>
         * 
         * @param returnCode
         *            value of {@code returnCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder returnCode(Integer returnCode) {
            this.returnCode = returnCode;
            this.changedFields = changedFields.add("returnCode");
            return this;
        }

        /**
         * <i>“The type of return code.”</i>
         * 
         * @param type
         *            value of {@code type} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder type(Win32LobAppReturnCodeType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Win32LobAppReturnCode build() {
            Win32LobAppReturnCode _x = new Win32LobAppReturnCode();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.win32LobAppReturnCode";
            _x.returnCode = returnCode;
            _x.type = type;
            return _x;
        }
    }

    private Win32LobAppReturnCode _copy() {
        Win32LobAppReturnCode _x = new Win32LobAppReturnCode();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.returnCode = returnCode;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppReturnCode[");
        b.append("returnCode=");
        b.append(this.returnCode);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
