package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Contains properties describing restart coordination following an app
 * installation.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "gracePeriodInMinutes", 
    "countdownDisplayBeforeRestartInMinutes", 
    "restartNotificationSnoozeDurationInMinutes"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppRestartSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("gracePeriodInMinutes")
    protected Integer gracePeriodInMinutes;

    @JsonProperty("countdownDisplayBeforeRestartInMinutes")
    protected Integer countdownDisplayBeforeRestartInMinutes;

    @JsonProperty("restartNotificationSnoozeDurationInMinutes")
    protected Integer restartNotificationSnoozeDurationInMinutes;

    protected Win32LobAppRestartSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppRestartSettings";
    }

    /**
     * <i>“The number of minutes to wait before restarting the device after an app
     * installation.”</i>
     * 
     * @return property gracePeriodInMinutes
     */
    @Property(name="gracePeriodInMinutes")
    @JsonIgnore
    public Optional<Integer> getGracePeriodInMinutes() {
        return Optional.ofNullable(gracePeriodInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * gracePeriodInMinutes} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of minutes to wait before restarting the device after an app
     * installation.”</i>
     * 
     * @param gracePeriodInMinutes
     *            new value of {@code gracePeriodInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code gracePeriodInMinutes} field changed
     */
    public Win32LobAppRestartSettings withGracePeriodInMinutes(Integer gracePeriodInMinutes) {
        Win32LobAppRestartSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRestartSettings");
        _x.gracePeriodInMinutes = gracePeriodInMinutes;
        return _x;
    }

    /**
     * <i>“The number of minutes before the restart time to display the countdown dialog
     * for pending restarts.”</i>
     * 
     * @return property countdownDisplayBeforeRestartInMinutes
     */
    @Property(name="countdownDisplayBeforeRestartInMinutes")
    @JsonIgnore
    public Optional<Integer> getCountdownDisplayBeforeRestartInMinutes() {
        return Optional.ofNullable(countdownDisplayBeforeRestartInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * countdownDisplayBeforeRestartInMinutes} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The number of minutes before the restart time to display the countdown dialog
     * for pending restarts.”</i>
     * 
     * @param countdownDisplayBeforeRestartInMinutes
     *            new value of {@code countdownDisplayBeforeRestartInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code countdownDisplayBeforeRestartInMinutes} field changed
     */
    public Win32LobAppRestartSettings withCountdownDisplayBeforeRestartInMinutes(Integer countdownDisplayBeforeRestartInMinutes) {
        Win32LobAppRestartSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRestartSettings");
        _x.countdownDisplayBeforeRestartInMinutes = countdownDisplayBeforeRestartInMinutes;
        return _x;
    }

    /**
     * <i>“The number of minutes to snooze the restart notification dialog when the snooze
     * button is selected.”</i>
     * 
     * @return property restartNotificationSnoozeDurationInMinutes
     */
    @Property(name="restartNotificationSnoozeDurationInMinutes")
    @JsonIgnore
    public Optional<Integer> getRestartNotificationSnoozeDurationInMinutes() {
        return Optional.ofNullable(restartNotificationSnoozeDurationInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * restartNotificationSnoozeDurationInMinutes} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The number of minutes to snooze the restart notification dialog when the snooze
     * button is selected.”</i>
     * 
     * @param restartNotificationSnoozeDurationInMinutes
     *            new value of {@code restartNotificationSnoozeDurationInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restartNotificationSnoozeDurationInMinutes} field changed
     */
    public Win32LobAppRestartSettings withRestartNotificationSnoozeDurationInMinutes(Integer restartNotificationSnoozeDurationInMinutes) {
        Win32LobAppRestartSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRestartSettings");
        _x.restartNotificationSnoozeDurationInMinutes = restartNotificationSnoozeDurationInMinutes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer gracePeriodInMinutes;
        private Integer countdownDisplayBeforeRestartInMinutes;
        private Integer restartNotificationSnoozeDurationInMinutes;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The number of minutes to wait before restarting the device after an app
         * installation.”</i>
         * 
         * @param gracePeriodInMinutes
         *            value of {@code gracePeriodInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder gracePeriodInMinutes(Integer gracePeriodInMinutes) {
            this.gracePeriodInMinutes = gracePeriodInMinutes;
            this.changedFields = changedFields.add("gracePeriodInMinutes");
            return this;
        }

        /**
         * <i>“The number of minutes before the restart time to display the countdown dialog
         * for pending restarts.”</i>
         * 
         * @param countdownDisplayBeforeRestartInMinutes
         *            value of {@code countdownDisplayBeforeRestartInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder countdownDisplayBeforeRestartInMinutes(Integer countdownDisplayBeforeRestartInMinutes) {
            this.countdownDisplayBeforeRestartInMinutes = countdownDisplayBeforeRestartInMinutes;
            this.changedFields = changedFields.add("countdownDisplayBeforeRestartInMinutes");
            return this;
        }

        /**
         * <i>“The number of minutes to snooze the restart notification dialog when the snooze
         * button is selected.”</i>
         * 
         * @param restartNotificationSnoozeDurationInMinutes
         *            value of {@code restartNotificationSnoozeDurationInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restartNotificationSnoozeDurationInMinutes(Integer restartNotificationSnoozeDurationInMinutes) {
            this.restartNotificationSnoozeDurationInMinutes = restartNotificationSnoozeDurationInMinutes;
            this.changedFields = changedFields.add("restartNotificationSnoozeDurationInMinutes");
            return this;
        }

        public Win32LobAppRestartSettings build() {
            Win32LobAppRestartSettings _x = new Win32LobAppRestartSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.win32LobAppRestartSettings";
            _x.gracePeriodInMinutes = gracePeriodInMinutes;
            _x.countdownDisplayBeforeRestartInMinutes = countdownDisplayBeforeRestartInMinutes;
            _x.restartNotificationSnoozeDurationInMinutes = restartNotificationSnoozeDurationInMinutes;
            return _x;
        }
    }

    private Win32LobAppRestartSettings _copy() {
        Win32LobAppRestartSettings _x = new Win32LobAppRestartSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.gracePeriodInMinutes = gracePeriodInMinutes;
        _x.countdownDisplayBeforeRestartInMinutes = countdownDisplayBeforeRestartInMinutes;
        _x.restartNotificationSnoozeDurationInMinutes = restartNotificationSnoozeDurationInMinutes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppRestartSettings[");
        b.append("gracePeriodInMinutes=");
        b.append(this.gracePeriodInMinutes);
        b.append(", ");
        b.append("countdownDisplayBeforeRestartInMinutes=");
        b.append(this.countdownDisplayBeforeRestartInMinutes);
        b.append(", ");
        b.append("restartNotificationSnoozeDurationInMinutes=");
        b.append(this.restartNotificationSnoozeDurationInMinutes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
