package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppDetectionOperator;


/**
 * <i>“Base class to detect a Win32 App”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "operator", 
    "detectionValue"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppRequirement implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("operator")
    protected Win32LobAppDetectionOperator operator;

    @JsonProperty("detectionValue")
    protected String detectionValue;

    protected Win32LobAppRequirement() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppRequirement";
    }

    /**
     * <i>“The operator for detection”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<Win32LobAppDetectionOperator> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operator for detection”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public Win32LobAppRequirement withOperator(Win32LobAppDetectionOperator operator) {
        Win32LobAppRequirement _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRequirement");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The detection value”</i>
     * 
     * @return property detectionValue
     */
    @Property(name="detectionValue")
    @JsonIgnore
    public Optional<String> getDetectionValue() {
        return Optional.ofNullable(detectionValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The detection value”</i>
     * 
     * @param detectionValue
     *            new value of {@code detectionValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionValue} field changed
     */
    public Win32LobAppRequirement withDetectionValue(String detectionValue) {
        Win32LobAppRequirement _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRequirement");
        _x.detectionValue = detectionValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private Win32LobAppRequirement _copy() {
        Win32LobAppRequirement _x = new Win32LobAppRequirement();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.operator = operator;
        _x.detectionValue = detectionValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppRequirement[");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("detectionValue=");
        b.append(this.detectionValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
