package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppRegistryRuleOperationType;
import odata.msgraph.client.beta.enums.Win32LobAppRuleOperator;
import odata.msgraph.client.beta.enums.Win32LobAppRuleType;


/**
 * <i>“A complex type to store registry rule data for a Win32 LOB app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "check32BitOn64System", 
    "keyPath", 
    "valueName", 
    "operationType", 
    "operator", 
    "comparisonValue"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppRegistryRule extends Win32LobAppRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("check32BitOn64System")
    protected Boolean check32BitOn64System;

    @JsonProperty("keyPath")
    protected String keyPath;

    @JsonProperty("valueName")
    protected String valueName;

    @JsonProperty("operationType")
    protected Win32LobAppRegistryRuleOperationType operationType;

    @JsonProperty("operator")
    protected Win32LobAppRuleOperator operator;

    @JsonProperty("comparisonValue")
    protected String comparisonValue;

    protected Win32LobAppRegistryRule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppRegistryRule";
    }

    /**
     * <i>“A value indicating whether to search the 32-bit registry on 64-bit systems.”</i>
     * 
     * @return property check32BitOn64System
     */
    @Property(name="check32BitOn64System")
    @JsonIgnore
    public Optional<Boolean> getCheck32BitOn64System() {
        return Optional.ofNullable(check32BitOn64System);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * check32BitOn64System} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A value indicating whether to search the 32-bit registry on 64-bit systems.”</i>
     * 
     * @param check32BitOn64System
     *            new value of {@code check32BitOn64System} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code check32BitOn64System} field changed
     */
    public Win32LobAppRegistryRule withCheck32BitOn64System(Boolean check32BitOn64System) {
        Win32LobAppRegistryRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryRule");
        _x.check32BitOn64System = check32BitOn64System;
        return _x;
    }

    /**
     * <i>“The full path of the registry entry containing the value to detect.”</i>
     * 
     * @return property keyPath
     */
    @Property(name="keyPath")
    @JsonIgnore
    public Optional<String> getKeyPath() {
        return Optional.ofNullable(keyPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keyPath} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The full path of the registry entry containing the value to detect.”</i>
     * 
     * @param keyPath
     *            new value of {@code keyPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyPath} field changed
     */
    public Win32LobAppRegistryRule withKeyPath(String keyPath) {
        Win32LobAppRegistryRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryRule");
        _x.keyPath = keyPath;
        return _x;
    }

    /**
     * <i>“The name of the registry value to detect.”</i>
     * 
     * @return property valueName
     */
    @Property(name="valueName")
    @JsonIgnore
    public Optional<String> getValueName() {
        return Optional.ofNullable(valueName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code valueName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name of the registry value to detect.”</i>
     * 
     * @param valueName
     *            new value of {@code valueName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code valueName} field changed
     */
    public Win32LobAppRegistryRule withValueName(String valueName) {
        Win32LobAppRegistryRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryRule");
        _x.valueName = valueName;
        return _x;
    }

    /**
     * <i>“The registry operation type.”</i>
     * 
     * @return property operationType
     */
    @Property(name="operationType")
    @JsonIgnore
    public Optional<Win32LobAppRegistryRuleOperationType> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operationType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The registry operation type.”</i>
     * 
     * @param operationType
     *            new value of {@code operationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operationType} field changed
     */
    public Win32LobAppRegistryRule withOperationType(Win32LobAppRegistryRuleOperationType operationType) {
        Win32LobAppRegistryRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryRule");
        _x.operationType = operationType;
        return _x;
    }

    /**
     * <i>“The operator for registry detection.”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<Win32LobAppRuleOperator> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operator for registry detection.”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public Win32LobAppRegistryRule withOperator(Win32LobAppRuleOperator operator) {
        Win32LobAppRegistryRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryRule");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The registry comparison value.”</i>
     * 
     * @return property comparisonValue
     */
    @Property(name="comparisonValue")
    @JsonIgnore
    public Optional<String> getComparisonValue() {
        return Optional.ofNullable(comparisonValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code comparisonValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The registry comparison value.”</i>
     * 
     * @param comparisonValue
     *            new value of {@code comparisonValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code comparisonValue} field changed
     */
    public Win32LobAppRegistryRule withComparisonValue(String comparisonValue) {
        Win32LobAppRegistryRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryRule");
        _x.comparisonValue = comparisonValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppRegistryRule() {
        return new Builder();
    }

    public static final class Builder {
        private Win32LobAppRuleType ruleType;
        private Boolean check32BitOn64System;
        private String keyPath;
        private String valueName;
        private Win32LobAppRegistryRuleOperationType operationType;
        private Win32LobAppRuleOperator operator;
        private String comparisonValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ruleType(Win32LobAppRuleType ruleType) {
            this.ruleType = ruleType;
            this.changedFields = changedFields.add("ruleType");
            return this;
        }

        /**
         * <i>“A value indicating whether to search the 32-bit registry on 64-bit systems.”</i>
         * 
         * @param check32BitOn64System
         *            value of {@code check32BitOn64System} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder check32BitOn64System(Boolean check32BitOn64System) {
            this.check32BitOn64System = check32BitOn64System;
            this.changedFields = changedFields.add("check32BitOn64System");
            return this;
        }

        /**
         * <i>“The full path of the registry entry containing the value to detect.”</i>
         * 
         * @param keyPath
         *            value of {@code keyPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyPath(String keyPath) {
            this.keyPath = keyPath;
            this.changedFields = changedFields.add("keyPath");
            return this;
        }

        /**
         * <i>“The name of the registry value to detect.”</i>
         * 
         * @param valueName
         *            value of {@code valueName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valueName(String valueName) {
            this.valueName = valueName;
            this.changedFields = changedFields.add("valueName");
            return this;
        }

        /**
         * <i>“The registry operation type.”</i>
         * 
         * @param operationType
         *            value of {@code operationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operationType(Win32LobAppRegistryRuleOperationType operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        /**
         * <i>“The operator for registry detection.”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(Win32LobAppRuleOperator operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“The registry comparison value.”</i>
         * 
         * @param comparisonValue
         *            value of {@code comparisonValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            this.changedFields = changedFields.add("comparisonValue");
            return this;
        }

        public Win32LobAppRegistryRule build() {
            Win32LobAppRegistryRule _x = new Win32LobAppRegistryRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.win32LobAppRegistryRule";
            _x.ruleType = ruleType;
            _x.check32BitOn64System = check32BitOn64System;
            _x.keyPath = keyPath;
            _x.valueName = valueName;
            _x.operationType = operationType;
            _x.operator = operator;
            _x.comparisonValue = comparisonValue;
            return _x;
        }
    }

    private Win32LobAppRegistryRule _copy() {
        Win32LobAppRegistryRule _x = new Win32LobAppRegistryRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ruleType = ruleType;
        _x.check32BitOn64System = check32BitOn64System;
        _x.keyPath = keyPath;
        _x.valueName = valueName;
        _x.operationType = operationType;
        _x.operator = operator;
        _x.comparisonValue = comparisonValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppRegistryRule[");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append(", ");
        b.append("check32BitOn64System=");
        b.append(this.check32BitOn64System);
        b.append(", ");
        b.append("keyPath=");
        b.append(this.keyPath);
        b.append(", ");
        b.append("valueName=");
        b.append(this.valueName);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("comparisonValue=");
        b.append(this.comparisonValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
