package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppDetectionOperator;
import odata.msgraph.client.beta.enums.Win32LobAppRegistryDetectionType;


/**
 * <i>“Contains registry properties to detect a Win32 App”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "check32BitOn64System", 
    "keyPath", 
    "valueName", 
    "detectionType", 
    "operator", 
    "detectionValue"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppRegistryDetection extends Win32LobAppDetection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("check32BitOn64System")
    protected Boolean check32BitOn64System;

    @JsonProperty("keyPath")
    protected String keyPath;

    @JsonProperty("valueName")
    protected String valueName;

    @JsonProperty("detectionType")
    protected Win32LobAppRegistryDetectionType detectionType;

    @JsonProperty("operator")
    protected Win32LobAppDetectionOperator operator;

    @JsonProperty("detectionValue")
    protected String detectionValue;

    protected Win32LobAppRegistryDetection() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppRegistryDetection";
    }

    /**
     * <i>“A value indicating whether this registry path is for checking 32-bit app on 64-
     * bit system”</i>
     * 
     * @return property check32BitOn64System
     */
    @Property(name="check32BitOn64System")
    @JsonIgnore
    public Optional<Boolean> getCheck32BitOn64System() {
        return Optional.ofNullable(check32BitOn64System);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * check32BitOn64System} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A value indicating whether this registry path is for checking 32-bit app on 64-
     * bit system”</i>
     * 
     * @param check32BitOn64System
     *            new value of {@code check32BitOn64System} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code check32BitOn64System} field changed
     */
    public Win32LobAppRegistryDetection withCheck32BitOn64System(Boolean check32BitOn64System) {
        Win32LobAppRegistryDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryDetection");
        _x.check32BitOn64System = check32BitOn64System;
        return _x;
    }

    /**
     * <i>“The registry key path to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @return property keyPath
     */
    @Property(name="keyPath")
    @JsonIgnore
    public Optional<String> getKeyPath() {
        return Optional.ofNullable(keyPath);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keyPath} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The registry key path to detect Win32 Line of Business (LoB) app”</i>
     * 
     * @param keyPath
     *            new value of {@code keyPath} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyPath} field changed
     */
    public Win32LobAppRegistryDetection withKeyPath(String keyPath) {
        Win32LobAppRegistryDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryDetection");
        _x.keyPath = keyPath;
        return _x;
    }

    /**
     * <i>“The registry value name”</i>
     * 
     * @return property valueName
     */
    @Property(name="valueName")
    @JsonIgnore
    public Optional<String> getValueName() {
        return Optional.ofNullable(valueName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code valueName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The registry value name”</i>
     * 
     * @param valueName
     *            new value of {@code valueName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code valueName} field changed
     */
    public Win32LobAppRegistryDetection withValueName(String valueName) {
        Win32LobAppRegistryDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryDetection");
        _x.valueName = valueName;
        return _x;
    }

    /**
     * <i>“The registry data detection type”</i>
     * 
     * @return property detectionType
     */
    @Property(name="detectionType")
    @JsonIgnore
    public Optional<Win32LobAppRegistryDetectionType> getDetectionType() {
        return Optional.ofNullable(detectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The registry data detection type”</i>
     * 
     * @param detectionType
     *            new value of {@code detectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionType} field changed
     */
    public Win32LobAppRegistryDetection withDetectionType(Win32LobAppRegistryDetectionType detectionType) {
        Win32LobAppRegistryDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryDetection");
        _x.detectionType = detectionType;
        return _x;
    }

    /**
     * <i>“The operator for registry data detection”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<Win32LobAppDetectionOperator> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operator for registry data detection”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public Win32LobAppRegistryDetection withOperator(Win32LobAppDetectionOperator operator) {
        Win32LobAppRegistryDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryDetection");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The registry detection value”</i>
     * 
     * @return property detectionValue
     */
    @Property(name="detectionValue")
    @JsonIgnore
    public Optional<String> getDetectionValue() {
        return Optional.ofNullable(detectionValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The registry detection value”</i>
     * 
     * @param detectionValue
     *            new value of {@code detectionValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionValue} field changed
     */
    public Win32LobAppRegistryDetection withDetectionValue(String detectionValue) {
        Win32LobAppRegistryDetection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppRegistryDetection");
        _x.detectionValue = detectionValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppRegistryDetection() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean check32BitOn64System;
        private String keyPath;
        private String valueName;
        private Win32LobAppRegistryDetectionType detectionType;
        private Win32LobAppDetectionOperator operator;
        private String detectionValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“A value indicating whether this registry path is for checking 32-bit app on 64-
         * bit system”</i>
         * 
         * @param check32BitOn64System
         *            value of {@code check32BitOn64System} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder check32BitOn64System(Boolean check32BitOn64System) {
            this.check32BitOn64System = check32BitOn64System;
            this.changedFields = changedFields.add("check32BitOn64System");
            return this;
        }

        /**
         * <i>“The registry key path to detect Win32 Line of Business (LoB) app”</i>
         * 
         * @param keyPath
         *            value of {@code keyPath} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyPath(String keyPath) {
            this.keyPath = keyPath;
            this.changedFields = changedFields.add("keyPath");
            return this;
        }

        /**
         * <i>“The registry value name”</i>
         * 
         * @param valueName
         *            value of {@code valueName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valueName(String valueName) {
            this.valueName = valueName;
            this.changedFields = changedFields.add("valueName");
            return this;
        }

        /**
         * <i>“The registry data detection type”</i>
         * 
         * @param detectionType
         *            value of {@code detectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionType(Win32LobAppRegistryDetectionType detectionType) {
            this.detectionType = detectionType;
            this.changedFields = changedFields.add("detectionType");
            return this;
        }

        /**
         * <i>“The operator for registry data detection”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(Win32LobAppDetectionOperator operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“The registry detection value”</i>
         * 
         * @param detectionValue
         *            value of {@code detectionValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionValue(String detectionValue) {
            this.detectionValue = detectionValue;
            this.changedFields = changedFields.add("detectionValue");
            return this;
        }

        public Win32LobAppRegistryDetection build() {
            Win32LobAppRegistryDetection _x = new Win32LobAppRegistryDetection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.win32LobAppRegistryDetection";
            _x.check32BitOn64System = check32BitOn64System;
            _x.keyPath = keyPath;
            _x.valueName = valueName;
            _x.detectionType = detectionType;
            _x.operator = operator;
            _x.detectionValue = detectionValue;
            return _x;
        }
    }

    private Win32LobAppRegistryDetection _copy() {
        Win32LobAppRegistryDetection _x = new Win32LobAppRegistryDetection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.check32BitOn64System = check32BitOn64System;
        _x.keyPath = keyPath;
        _x.valueName = valueName;
        _x.detectionType = detectionType;
        _x.operator = operator;
        _x.detectionValue = detectionValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppRegistryDetection[");
        b.append("check32BitOn64System=");
        b.append(this.check32BitOn64System);
        b.append(", ");
        b.append("keyPath=");
        b.append(this.keyPath);
        b.append(", ");
        b.append("valueName=");
        b.append(this.valueName);
        b.append(", ");
        b.append("detectionType=");
        b.append(this.detectionType);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("detectionValue=");
        b.append(this.detectionValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
