package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.RunAsAccountType;
import odata.msgraph.client.beta.enums.Win32LobAppRuleOperator;
import odata.msgraph.client.beta.enums.Win32LobAppRuleType;
import odata.msgraph.client.beta.enums.Win32LobPowerShellScriptRuleOperationType;


/**
 * <i>“A complex type to store the PowerShell script rule data for a Win32 LOB app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "enforceSignatureCheck", 
    "runAs32Bit", 
    "runAsAccount", 
    "scriptContent", 
    "operationType", 
    "operator", 
    "comparisonValue"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppPowerShellScriptRule extends Win32LobAppRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enforceSignatureCheck")
    protected Boolean enforceSignatureCheck;

    @JsonProperty("runAs32Bit")
    protected Boolean runAs32Bit;

    @JsonProperty("runAsAccount")
    protected RunAsAccountType runAsAccount;

    @JsonProperty("scriptContent")
    protected String scriptContent;

    @JsonProperty("operationType")
    protected Win32LobPowerShellScriptRuleOperationType operationType;

    @JsonProperty("operator")
    protected Win32LobAppRuleOperator operator;

    @JsonProperty("comparisonValue")
    protected String comparisonValue;

    protected Win32LobAppPowerShellScriptRule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppPowerShellScriptRule";
    }

    /**
     * <i>“The display name for the rule. Do not specify this value if the rule is used for
     * detection.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name for the rule. Do not specify this value if the rule is used for
     * detection.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public Win32LobAppPowerShellScriptRule withDisplayName(String displayName) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“A value indicating whether a signature check is enforced.”</i>
     * 
     * @return property enforceSignatureCheck
     */
    @Property(name="enforceSignatureCheck")
    @JsonIgnore
    public Optional<Boolean> getEnforceSignatureCheck() {
        return Optional.ofNullable(enforceSignatureCheck);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enforceSignatureCheck} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A value indicating whether a signature check is enforced.”</i>
     * 
     * @param enforceSignatureCheck
     *            new value of {@code enforceSignatureCheck} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enforceSignatureCheck} field changed
     */
    public Win32LobAppPowerShellScriptRule withEnforceSignatureCheck(Boolean enforceSignatureCheck) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.enforceSignatureCheck = enforceSignatureCheck;
        return _x;
    }

    /**
     * <i>“A value indicating whether the script should run as 32-bit.”</i>
     * 
     * @return property runAs32Bit
     */
    @Property(name="runAs32Bit")
    @JsonIgnore
    public Optional<Boolean> getRunAs32Bit() {
        return Optional.ofNullable(runAs32Bit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAs32Bit} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“A value indicating whether the script should run as 32-bit.”</i>
     * 
     * @param runAs32Bit
     *            new value of {@code runAs32Bit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAs32Bit} field changed
     */
    public Win32LobAppPowerShellScriptRule withRunAs32Bit(Boolean runAs32Bit) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.runAs32Bit = runAs32Bit;
        return _x;
    }

    /**
     * <i>“The execution context of the script. Do not specify this value if the rule is
     * used for detection. Script detection rules will run in the same context as the
     * associated app install context.”</i>
     * 
     * @return property runAsAccount
     */
    @Property(name="runAsAccount")
    @JsonIgnore
    public Optional<RunAsAccountType> getRunAsAccount() {
        return Optional.ofNullable(runAsAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAsAccount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The execution context of the script. Do not specify this value if the rule is
     * used for detection. Script detection rules will run in the same context as the
     * associated app install context.”</i>
     * 
     * @param runAsAccount
     *            new value of {@code runAsAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAsAccount} field changed
     */
    public Win32LobAppPowerShellScriptRule withRunAsAccount(RunAsAccountType runAsAccount) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.runAsAccount = runAsAccount;
        return _x;
    }

    /**
     * <i>“The base64-encoded script content.”</i>
     * 
     * @return property scriptContent
     */
    @Property(name="scriptContent")
    @JsonIgnore
    public Optional<String> getScriptContent() {
        return Optional.ofNullable(scriptContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scriptContent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The base64-encoded script content.”</i>
     * 
     * @param scriptContent
     *            new value of {@code scriptContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scriptContent} field changed
     */
    public Win32LobAppPowerShellScriptRule withScriptContent(String scriptContent) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.scriptContent = scriptContent;
        return _x;
    }

    /**
     * <i>“The script output comparison operation type. Use NotConfigured (the default
     * value) if the rule is used for detection.”</i>
     * 
     * @return property operationType
     */
    @Property(name="operationType")
    @JsonIgnore
    public Optional<Win32LobPowerShellScriptRuleOperationType> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operationType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The script output comparison operation type. Use NotConfigured (the default
     * value) if the rule is used for detection.”</i>
     * 
     * @param operationType
     *            new value of {@code operationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operationType} field changed
     */
    public Win32LobAppPowerShellScriptRule withOperationType(Win32LobPowerShellScriptRuleOperationType operationType) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.operationType = operationType;
        return _x;
    }

    /**
     * <i>“The script output operator. Use NotConfigured (the default value) if the rule is
     * used for detection.”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<Win32LobAppRuleOperator> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The script output operator. Use NotConfigured (the default value) if the rule is
     * used for detection.”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public Win32LobAppPowerShellScriptRule withOperator(Win32LobAppRuleOperator operator) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The script output comparison value. Do not specify a value if the rule is used
     * for detection.”</i>
     * 
     * @return property comparisonValue
     */
    @Property(name="comparisonValue")
    @JsonIgnore
    public Optional<String> getComparisonValue() {
        return Optional.ofNullable(comparisonValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code comparisonValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The script output comparison value. Do not specify a value if the rule is used
     * for detection.”</i>
     * 
     * @param comparisonValue
     *            new value of {@code comparisonValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code comparisonValue} field changed
     */
    public Win32LobAppPowerShellScriptRule withComparisonValue(String comparisonValue) {
        Win32LobAppPowerShellScriptRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppPowerShellScriptRule");
        _x.comparisonValue = comparisonValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppPowerShellScriptRule() {
        return new Builder();
    }

    public static final class Builder {
        private Win32LobAppRuleType ruleType;
        private String displayName;
        private Boolean enforceSignatureCheck;
        private Boolean runAs32Bit;
        private RunAsAccountType runAsAccount;
        private String scriptContent;
        private Win32LobPowerShellScriptRuleOperationType operationType;
        private Win32LobAppRuleOperator operator;
        private String comparisonValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ruleType(Win32LobAppRuleType ruleType) {
            this.ruleType = ruleType;
            this.changedFields = changedFields.add("ruleType");
            return this;
        }

        /**
         * <i>“The display name for the rule. Do not specify this value if the rule is used for
         * detection.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“A value indicating whether a signature check is enforced.”</i>
         * 
         * @param enforceSignatureCheck
         *            value of {@code enforceSignatureCheck} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enforceSignatureCheck(Boolean enforceSignatureCheck) {
            this.enforceSignatureCheck = enforceSignatureCheck;
            this.changedFields = changedFields.add("enforceSignatureCheck");
            return this;
        }

        /**
         * <i>“A value indicating whether the script should run as 32-bit.”</i>
         * 
         * @param runAs32Bit
         *            value of {@code runAs32Bit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAs32Bit(Boolean runAs32Bit) {
            this.runAs32Bit = runAs32Bit;
            this.changedFields = changedFields.add("runAs32Bit");
            return this;
        }

        /**
         * <i>“The execution context of the script. Do not specify this value if the rule is
         * used for detection. Script detection rules will run in the same context as the
         * associated app install context.”</i>
         * 
         * @param runAsAccount
         *            value of {@code runAsAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAsAccount(RunAsAccountType runAsAccount) {
            this.runAsAccount = runAsAccount;
            this.changedFields = changedFields.add("runAsAccount");
            return this;
        }

        /**
         * <i>“The base64-encoded script content.”</i>
         * 
         * @param scriptContent
         *            value of {@code scriptContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptContent(String scriptContent) {
            this.scriptContent = scriptContent;
            this.changedFields = changedFields.add("scriptContent");
            return this;
        }

        /**
         * <i>“The script output comparison operation type. Use NotConfigured (the default
         * value) if the rule is used for detection.”</i>
         * 
         * @param operationType
         *            value of {@code operationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operationType(Win32LobPowerShellScriptRuleOperationType operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        /**
         * <i>“The script output operator. Use NotConfigured (the default value) if the rule is
         * used for detection.”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(Win32LobAppRuleOperator operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“The script output comparison value. Do not specify a value if the rule is used
         * for detection.”</i>
         * 
         * @param comparisonValue
         *            value of {@code comparisonValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            this.changedFields = changedFields.add("comparisonValue");
            return this;
        }

        public Win32LobAppPowerShellScriptRule build() {
            Win32LobAppPowerShellScriptRule _x = new Win32LobAppPowerShellScriptRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.win32LobAppPowerShellScriptRule";
            _x.ruleType = ruleType;
            _x.displayName = displayName;
            _x.enforceSignatureCheck = enforceSignatureCheck;
            _x.runAs32Bit = runAs32Bit;
            _x.runAsAccount = runAsAccount;
            _x.scriptContent = scriptContent;
            _x.operationType = operationType;
            _x.operator = operator;
            _x.comparisonValue = comparisonValue;
            return _x;
        }
    }

    private Win32LobAppPowerShellScriptRule _copy() {
        Win32LobAppPowerShellScriptRule _x = new Win32LobAppPowerShellScriptRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ruleType = ruleType;
        _x.displayName = displayName;
        _x.enforceSignatureCheck = enforceSignatureCheck;
        _x.runAs32Bit = runAs32Bit;
        _x.runAsAccount = runAsAccount;
        _x.scriptContent = scriptContent;
        _x.operationType = operationType;
        _x.operator = operator;
        _x.comparisonValue = comparisonValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppPowerShellScriptRule[");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enforceSignatureCheck=");
        b.append(this.enforceSignatureCheck);
        b.append(", ");
        b.append("runAs32Bit=");
        b.append(this.runAs32Bit);
        b.append(", ");
        b.append("runAsAccount=");
        b.append(this.runAsAccount);
        b.append(", ");
        b.append("scriptContent=");
        b.append(this.scriptContent);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("comparisonValue=");
        b.append(this.comparisonValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
