package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.Win32LobAppFileSystemOperationType;
import odata.msgraph.client.beta.enums.Win32LobAppRuleOperator;
import odata.msgraph.client.beta.enums.Win32LobAppRuleType;


/**
 * <i>“A complex type to store file or folder rule data for a Win32 LOB app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "path", 
    "fileOrFolderName", 
    "check32BitOn64System", 
    "operationType", 
    "operator", 
    "comparisonValue"})
@JsonInclude(Include.NON_NULL)
public class Win32LobAppFileSystemRule extends Win32LobAppRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("path")
    protected String path;

    @JsonProperty("fileOrFolderName")
    protected String fileOrFolderName;

    @JsonProperty("check32BitOn64System")
    protected Boolean check32BitOn64System;

    @JsonProperty("operationType")
    protected Win32LobAppFileSystemOperationType operationType;

    @JsonProperty("operator")
    protected Win32LobAppRuleOperator operator;

    @JsonProperty("comparisonValue")
    protected String comparisonValue;

    protected Win32LobAppFileSystemRule() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.win32LobAppFileSystemRule";
    }

    /**
     * <i>“The file or folder path to look up.”</i>
     * 
     * @return property path
     */
    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code path} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The file or folder path to look up.”</i>
     * 
     * @param path
     *            new value of {@code path} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code path} field changed
     */
    public Win32LobAppFileSystemRule withPath(String path) {
        Win32LobAppFileSystemRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemRule");
        _x.path = path;
        return _x;
    }

    /**
     * <i>“The file or folder name to look up.”</i>
     * 
     * @return property fileOrFolderName
     */
    @Property(name="fileOrFolderName")
    @JsonIgnore
    public Optional<String> getFileOrFolderName() {
        return Optional.ofNullable(fileOrFolderName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileOrFolderName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The file or folder name to look up.”</i>
     * 
     * @param fileOrFolderName
     *            new value of {@code fileOrFolderName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileOrFolderName} field changed
     */
    public Win32LobAppFileSystemRule withFileOrFolderName(String fileOrFolderName) {
        Win32LobAppFileSystemRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemRule");
        _x.fileOrFolderName = fileOrFolderName;
        return _x;
    }

    /**
     * <i>“A value indicating whether to expand environment variables in the 32-bit context
     * on 64-bit systems.”</i>
     * 
     * @return property check32BitOn64System
     */
    @Property(name="check32BitOn64System")
    @JsonIgnore
    public Optional<Boolean> getCheck32BitOn64System() {
        return Optional.ofNullable(check32BitOn64System);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * check32BitOn64System} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A value indicating whether to expand environment variables in the 32-bit context
     * on 64-bit systems.”</i>
     * 
     * @param check32BitOn64System
     *            new value of {@code check32BitOn64System} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code check32BitOn64System} field changed
     */
    public Win32LobAppFileSystemRule withCheck32BitOn64System(Boolean check32BitOn64System) {
        Win32LobAppFileSystemRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemRule");
        _x.check32BitOn64System = check32BitOn64System;
        return _x;
    }

    /**
     * <i>“The file system operation type.”</i>
     * 
     * @return property operationType
     */
    @Property(name="operationType")
    @JsonIgnore
    public Optional<Win32LobAppFileSystemOperationType> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operationType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The file system operation type.”</i>
     * 
     * @param operationType
     *            new value of {@code operationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operationType} field changed
     */
    public Win32LobAppFileSystemRule withOperationType(Win32LobAppFileSystemOperationType operationType) {
        Win32LobAppFileSystemRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemRule");
        _x.operationType = operationType;
        return _x;
    }

    /**
     * <i>“The operator for file or folder detection.”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<Win32LobAppRuleOperator> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operator for file or folder detection.”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public Win32LobAppFileSystemRule withOperator(Win32LobAppRuleOperator operator) {
        Win32LobAppFileSystemRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemRule");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The file or folder comparison value.”</i>
     * 
     * @return property comparisonValue
     */
    @Property(name="comparisonValue")
    @JsonIgnore
    public Optional<String> getComparisonValue() {
        return Optional.ofNullable(comparisonValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code comparisonValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The file or folder comparison value.”</i>
     * 
     * @param comparisonValue
     *            new value of {@code comparisonValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code comparisonValue} field changed
     */
    public Win32LobAppFileSystemRule withComparisonValue(String comparisonValue) {
        Win32LobAppFileSystemRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.win32LobAppFileSystemRule");
        _x.comparisonValue = comparisonValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWin32LobAppFileSystemRule() {
        return new Builder();
    }

    public static final class Builder {
        private Win32LobAppRuleType ruleType;
        private String path;
        private String fileOrFolderName;
        private Boolean check32BitOn64System;
        private Win32LobAppFileSystemOperationType operationType;
        private Win32LobAppRuleOperator operator;
        private String comparisonValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ruleType(Win32LobAppRuleType ruleType) {
            this.ruleType = ruleType;
            this.changedFields = changedFields.add("ruleType");
            return this;
        }

        /**
         * <i>“The file or folder path to look up.”</i>
         * 
         * @param path
         *            value of {@code path} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        /**
         * <i>“The file or folder name to look up.”</i>
         * 
         * @param fileOrFolderName
         *            value of {@code fileOrFolderName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileOrFolderName(String fileOrFolderName) {
            this.fileOrFolderName = fileOrFolderName;
            this.changedFields = changedFields.add("fileOrFolderName");
            return this;
        }

        /**
         * <i>“A value indicating whether to expand environment variables in the 32-bit context
         * on 64-bit systems.”</i>
         * 
         * @param check32BitOn64System
         *            value of {@code check32BitOn64System} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder check32BitOn64System(Boolean check32BitOn64System) {
            this.check32BitOn64System = check32BitOn64System;
            this.changedFields = changedFields.add("check32BitOn64System");
            return this;
        }

        /**
         * <i>“The file system operation type.”</i>
         * 
         * @param operationType
         *            value of {@code operationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operationType(Win32LobAppFileSystemOperationType operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        /**
         * <i>“The operator for file or folder detection.”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(Win32LobAppRuleOperator operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“The file or folder comparison value.”</i>
         * 
         * @param comparisonValue
         *            value of {@code comparisonValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            this.changedFields = changedFields.add("comparisonValue");
            return this;
        }

        public Win32LobAppFileSystemRule build() {
            Win32LobAppFileSystemRule _x = new Win32LobAppFileSystemRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.win32LobAppFileSystemRule";
            _x.ruleType = ruleType;
            _x.path = path;
            _x.fileOrFolderName = fileOrFolderName;
            _x.check32BitOn64System = check32BitOn64System;
            _x.operationType = operationType;
            _x.operator = operator;
            _x.comparisonValue = comparisonValue;
            return _x;
        }
    }

    private Win32LobAppFileSystemRule _copy() {
        Win32LobAppFileSystemRule _x = new Win32LobAppFileSystemRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ruleType = ruleType;
        _x.path = path;
        _x.fileOrFolderName = fileOrFolderName;
        _x.check32BitOn64System = check32BitOn64System;
        _x.operationType = operationType;
        _x.operator = operator;
        _x.comparisonValue = comparisonValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Win32LobAppFileSystemRule[");
        b.append("ruleType=");
        b.append(this.ruleType);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append(", ");
        b.append("fileOrFolderName=");
        b.append(this.fileOrFolderName);
        b.append(", ");
        b.append("check32BitOn64System=");
        b.append(this.check32BitOn64System);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("comparisonValue=");
        b.append(this.comparisonValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
