package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.WebsiteType;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "address", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class Website implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("type")
    protected WebsiteType type;

    @JsonProperty("address")
    protected String address;

    @JsonProperty("displayName")
    protected String displayName;

    protected Website() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.website";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<WebsiteType> getType() {
        return Optional.ofNullable(type);
    }

    public Website withType(WebsiteType type) {
        Website _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.website");
        _x.type = type;
        return _x;
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    public Website withAddress(String address) {
        Website _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.website");
        _x.address = address;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Website withDisplayName(String displayName) {
        Website _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.website");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private WebsiteType type;
        private String address;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder type(WebsiteType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Website build() {
            Website _x = new Website();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.website";
            _x.type = type;
            _x.address = address;
            _x.displayName = displayName;
            return _x;
        }
    }

    private Website _copy() {
        Website _x = new Website();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.type = type;
        _x.address = address;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Website[");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
