package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "homePageUrl", 
    "redirectUris", 
    "oauth2AllowImplicitFlow", 
    "logoutUrl", 
    "implicitGrantSettings"})
@JsonInclude(Include.NON_NULL)
public class WebApplication implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("homePageUrl")
    protected String homePageUrl;

    @JsonProperty("redirectUris")
    protected List<String> redirectUris;

    @JsonProperty("redirectUris@nextLink")
    protected String redirectUrisNextLink;

    @JsonProperty("oauth2AllowImplicitFlow")
    protected Boolean oauth2AllowImplicitFlow;

    @JsonProperty("logoutUrl")
    protected String logoutUrl;

    @JsonProperty("implicitGrantSettings")
    protected ImplicitGrantSettings implicitGrantSettings;

    protected WebApplication() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.webApplication";
    }

    @Property(name="homePageUrl")
    @JsonIgnore
    public Optional<String> getHomePageUrl() {
        return Optional.ofNullable(homePageUrl);
    }

    public WebApplication withHomePageUrl(String homePageUrl) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.homePageUrl = homePageUrl;
        return _x;
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris() {
        return new CollectionPage<String>(contextPath, String.class, redirectUris, Optional.ofNullable(redirectUrisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="redirectUris")
    @JsonIgnore
    public CollectionPage<String> getRedirectUris(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, redirectUris, Optional.ofNullable(redirectUrisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="oauth2AllowImplicitFlow")
    @JsonIgnore
    public Optional<Boolean> getOauth2AllowImplicitFlow() {
        return Optional.ofNullable(oauth2AllowImplicitFlow);
    }

    public WebApplication withOauth2AllowImplicitFlow(Boolean oauth2AllowImplicitFlow) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
        return _x;
    }

    @Property(name="logoutUrl")
    @JsonIgnore
    public Optional<String> getLogoutUrl() {
        return Optional.ofNullable(logoutUrl);
    }

    public WebApplication withLogoutUrl(String logoutUrl) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.logoutUrl = logoutUrl;
        return _x;
    }

    @Property(name="implicitGrantSettings")
    @JsonIgnore
    public Optional<ImplicitGrantSettings> getImplicitGrantSettings() {
        return Optional.ofNullable(implicitGrantSettings);
    }

    public WebApplication withImplicitGrantSettings(ImplicitGrantSettings implicitGrantSettings) {
        WebApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.webApplication");
        _x.implicitGrantSettings = implicitGrantSettings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String homePageUrl;
        private List<String> redirectUris;
        private String redirectUrisNextLink;
        private Boolean oauth2AllowImplicitFlow;
        private String logoutUrl;
        private ImplicitGrantSettings implicitGrantSettings;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            this.changedFields = changedFields.add("homePageUrl");
            return this;
        }

        public Builder redirectUris(List<String> redirectUris) {
            this.redirectUris = redirectUris;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public Builder redirectUris(String... redirectUris) {
            return redirectUris(Arrays.asList(redirectUris));
        }

        public Builder redirectUrisNextLink(String redirectUrisNextLink) {
            this.redirectUrisNextLink = redirectUrisNextLink;
            this.changedFields = changedFields.add("redirectUris");
            return this;
        }

        public Builder oauth2AllowImplicitFlow(Boolean oauth2AllowImplicitFlow) {
            this.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
            this.changedFields = changedFields.add("oauth2AllowImplicitFlow");
            return this;
        }

        public Builder logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            this.changedFields = changedFields.add("logoutUrl");
            return this;
        }

        public Builder implicitGrantSettings(ImplicitGrantSettings implicitGrantSettings) {
            this.implicitGrantSettings = implicitGrantSettings;
            this.changedFields = changedFields.add("implicitGrantSettings");
            return this;
        }

        public WebApplication build() {
            WebApplication _x = new WebApplication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.webApplication";
            _x.homePageUrl = homePageUrl;
            _x.redirectUris = redirectUris;
            _x.redirectUrisNextLink = redirectUrisNextLink;
            _x.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
            _x.logoutUrl = logoutUrl;
            _x.implicitGrantSettings = implicitGrantSettings;
            return _x;
        }
    }

    private WebApplication _copy() {
        WebApplication _x = new WebApplication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.homePageUrl = homePageUrl;
        _x.redirectUris = redirectUris;
        _x.oauth2AllowImplicitFlow = oauth2AllowImplicitFlow;
        _x.logoutUrl = logoutUrl;
        _x.implicitGrantSettings = implicitGrantSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WebApplication[");
        b.append("homePageUrl=");
        b.append(this.homePageUrl);
        b.append(", ");
        b.append("redirectUris=");
        b.append(this.redirectUris);
        b.append(", ");
        b.append("oauth2AllowImplicitFlow=");
        b.append(this.oauth2AllowImplicitFlow);
        b.append(", ");
        b.append("logoutUrl=");
        b.append(this.logoutUrl);
        b.append(", ");
        b.append("implicitGrantSettings=");
        b.append(this.implicitGrantSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
