package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;
import odata.msgraph.client.beta.enums.VppTokenActionFailureReason;


/**
 * <i>“The status of the revoke licenses action performed on the Apple Volume Purchase
 * Program token.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "totalLicensesCount", 
    "failedLicensesCount", 
    "actionFailureReason"})
@JsonInclude(Include.NON_NULL)
public class VppTokenRevokeLicensesActionResult extends VppTokenActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("totalLicensesCount")
    protected Integer totalLicensesCount;

    @JsonProperty("failedLicensesCount")
    protected Integer failedLicensesCount;

    @JsonProperty("actionFailureReason")
    protected VppTokenActionFailureReason actionFailureReason;

    protected VppTokenRevokeLicensesActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vppTokenRevokeLicensesActionResult";
    }

    /**
     * <i>“A count of the number of licenses that were attempted to revoke.”</i>
     * 
     * @return property totalLicensesCount
     */
    @Property(name="totalLicensesCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicensesCount() {
        return Optional.ofNullable(totalLicensesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * totalLicensesCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A count of the number of licenses that were attempted to revoke.”</i>
     * 
     * @param totalLicensesCount
     *            new value of {@code totalLicensesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicensesCount} field changed
     */
    public VppTokenRevokeLicensesActionResult withTotalLicensesCount(Integer totalLicensesCount) {
        VppTokenRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenRevokeLicensesActionResult");
        _x.totalLicensesCount = totalLicensesCount;
        return _x;
    }

    /**
     * <i>“A count of the number of licenses that failed to revoke.”</i>
     * 
     * @return property failedLicensesCount
     */
    @Property(name="failedLicensesCount")
    @JsonIgnore
    public Optional<Integer> getFailedLicensesCount() {
        return Optional.ofNullable(failedLicensesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * failedLicensesCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A count of the number of licenses that failed to revoke.”</i>
     * 
     * @param failedLicensesCount
     *            new value of {@code failedLicensesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedLicensesCount} field changed
     */
    public VppTokenRevokeLicensesActionResult withFailedLicensesCount(Integer failedLicensesCount) {
        VppTokenRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenRevokeLicensesActionResult");
        _x.failedLicensesCount = failedLicensesCount;
        return _x;
    }

    /**
     * <i>“The reason for the revoke licenses action failure.”</i>
     * 
     * @return property actionFailureReason
     */
    @Property(name="actionFailureReason")
    @JsonIgnore
    public Optional<VppTokenActionFailureReason> getActionFailureReason() {
        return Optional.ofNullable(actionFailureReason);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * actionFailureReason} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The reason for the revoke licenses action failure.”</i>
     * 
     * @param actionFailureReason
     *            new value of {@code actionFailureReason} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionFailureReason} field changed
     */
    public VppTokenRevokeLicensesActionResult withActionFailureReason(VppTokenActionFailureReason actionFailureReason) {
        VppTokenRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenRevokeLicensesActionResult");
        _x.actionFailureReason = actionFailureReason;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderVppTokenRevokeLicensesActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private Integer totalLicensesCount;
        private Integer failedLicensesCount;
        private VppTokenActionFailureReason actionFailureReason;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“A count of the number of licenses that were attempted to revoke.”</i>
         * 
         * @param totalLicensesCount
         *            value of {@code totalLicensesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicensesCount(Integer totalLicensesCount) {
            this.totalLicensesCount = totalLicensesCount;
            this.changedFields = changedFields.add("totalLicensesCount");
            return this;
        }

        /**
         * <i>“A count of the number of licenses that failed to revoke.”</i>
         * 
         * @param failedLicensesCount
         *            value of {@code failedLicensesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedLicensesCount(Integer failedLicensesCount) {
            this.failedLicensesCount = failedLicensesCount;
            this.changedFields = changedFields.add("failedLicensesCount");
            return this;
        }

        /**
         * <i>“The reason for the revoke licenses action failure.”</i>
         * 
         * @param actionFailureReason
         *            value of {@code actionFailureReason} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionFailureReason(VppTokenActionFailureReason actionFailureReason) {
            this.actionFailureReason = actionFailureReason;
            this.changedFields = changedFields.add("actionFailureReason");
            return this;
        }

        public VppTokenRevokeLicensesActionResult build() {
            VppTokenRevokeLicensesActionResult _x = new VppTokenRevokeLicensesActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.vppTokenRevokeLicensesActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.totalLicensesCount = totalLicensesCount;
            _x.failedLicensesCount = failedLicensesCount;
            _x.actionFailureReason = actionFailureReason;
            return _x;
        }
    }

    private VppTokenRevokeLicensesActionResult _copy() {
        VppTokenRevokeLicensesActionResult _x = new VppTokenRevokeLicensesActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.totalLicensesCount = totalLicensesCount;
        _x.failedLicensesCount = failedLicensesCount;
        _x.actionFailureReason = actionFailureReason;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VppTokenRevokeLicensesActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("totalLicensesCount=");
        b.append(this.totalLicensesCount);
        b.append(", ");
        b.append("failedLicensesCount=");
        b.append(this.failedLicensesCount);
        b.append(", ");
        b.append("actionFailureReason=");
        b.append(this.actionFailureReason);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
