package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“The status of the action performed with an Apple Volume Purchase Program token.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "actionName", 
    "actionState", 
    "startDateTime", 
    "lastUpdatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class VppTokenActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("actionName")
    protected String actionName;

    @JsonProperty("actionState")
    protected ActionState actionState;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    protected VppTokenActionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vppTokenActionResult";
    }

    /**
     * <i>“Action name”</i>
     * 
     * @return property actionName
     */
    @Property(name="actionName")
    @JsonIgnore
    public Optional<String> getActionName() {
        return Optional.ofNullable(actionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actionName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Action name”</i>
     * 
     * @param actionName
     *            new value of {@code actionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionName} field changed
     */
    public VppTokenActionResult withActionName(String actionName) {
        VppTokenActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenActionResult");
        _x.actionName = actionName;
        return _x;
    }

    /**
     * <i>“State of the action”</i>
     * 
     * @return property actionState
     */
    @Property(name="actionState")
    @JsonIgnore
    public Optional<ActionState> getActionState() {
        return Optional.ofNullable(actionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“State of the action”</i>
     * 
     * @param actionState
     *            new value of {@code actionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionState} field changed
     */
    public VppTokenActionResult withActionState(ActionState actionState) {
        VppTokenActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenActionResult");
        _x.actionState = actionState;
        return _x;
    }

    /**
     * <i>“Time the action was initiated”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time the action was initiated”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public VppTokenActionResult withStartDateTime(OffsetDateTime startDateTime) {
        VppTokenActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenActionResult");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“Time the action state was last updated”</i>
     * 
     * @return property lastUpdatedDateTime
     */
    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdatedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time the action state was last updated”</i>
     * 
     * @param lastUpdatedDateTime
     *            new value of {@code lastUpdatedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdatedDateTime} field changed
     */
    public VppTokenActionResult withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        VppTokenActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vppTokenActionResult");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Action name”</i>
         * 
         * @param actionName
         *            value of {@code actionName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        /**
         * <i>“State of the action”</i>
         * 
         * @param actionState
         *            value of {@code actionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        /**
         * <i>“Time the action was initiated”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Time the action state was last updated”</i>
         * 
         * @param lastUpdatedDateTime
         *            value of {@code lastUpdatedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public VppTokenActionResult build() {
            VppTokenActionResult _x = new VppTokenActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.vppTokenActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            return _x;
        }
    }

    private VppTokenActionResult _copy() {
        VppTokenActionResult _x = new VppTokenActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VppTokenActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
