package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“VPN Route definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "destinationPrefix", 
    "prefixSize"})
@JsonInclude(Include.NON_NULL)
public class VpnRoute implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("destinationPrefix")
    protected String destinationPrefix;

    @JsonProperty("prefixSize")
    protected Integer prefixSize;

    protected VpnRoute() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vpnRoute";
    }

    /**
     * <i>“Destination prefix (IPv4/v6 address).”</i>
     * 
     * @return property destinationPrefix
     */
    @Property(name="destinationPrefix")
    @JsonIgnore
    public Optional<String> getDestinationPrefix() {
        return Optional.ofNullable(destinationPrefix);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code destinationPrefix
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Destination prefix (IPv4/v6 address).”</i>
     * 
     * @param destinationPrefix
     *            new value of {@code destinationPrefix} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code destinationPrefix} field changed
     */
    public VpnRoute withDestinationPrefix(String destinationPrefix) {
        VpnRoute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnRoute");
        _x.destinationPrefix = destinationPrefix;
        return _x;
    }

    /**
     * <i>“Prefix size. (1-32). Valid values 1 to 32”</i>
     * 
     * @return property prefixSize
     */
    @Property(name="prefixSize")
    @JsonIgnore
    public Optional<Integer> getPrefixSize() {
        return Optional.ofNullable(prefixSize);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code prefixSize} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Prefix size. (1-32). Valid values 1 to 32”</i>
     * 
     * @param prefixSize
     *            new value of {@code prefixSize} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code prefixSize} field changed
     */
    public VpnRoute withPrefixSize(Integer prefixSize) {
        VpnRoute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnRoute");
        _x.prefixSize = prefixSize;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String destinationPrefix;
        private Integer prefixSize;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Destination prefix (IPv4/v6 address).”</i>
         * 
         * @param destinationPrefix
         *            value of {@code destinationPrefix} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            this.changedFields = changedFields.add("destinationPrefix");
            return this;
        }

        /**
         * <i>“Prefix size. (1-32). Valid values 1 to 32”</i>
         * 
         * @param prefixSize
         *            value of {@code prefixSize} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder prefixSize(Integer prefixSize) {
            this.prefixSize = prefixSize;
            this.changedFields = changedFields.add("prefixSize");
            return this;
        }

        public VpnRoute build() {
            VpnRoute _x = new VpnRoute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.vpnRoute";
            _x.destinationPrefix = destinationPrefix;
            _x.prefixSize = prefixSize;
            return _x;
        }
    }

    private VpnRoute _copy() {
        VpnRoute _x = new VpnRoute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.destinationPrefix = destinationPrefix;
        _x.prefixSize = prefixSize;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VpnRoute[");
        b.append("destinationPrefix=");
        b.append(this.destinationPrefix);
        b.append(", ");
        b.append("prefixSize=");
        b.append(this.prefixSize);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
