package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“VPN Proxy Server.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "automaticConfigurationScriptUrl", 
    "address", 
    "port"})
@JsonInclude(Include.NON_NULL)
public class VpnProxyServer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("automaticConfigurationScriptUrl")
    protected String automaticConfigurationScriptUrl;

    @JsonProperty("address")
    protected String address;

    @JsonProperty("port")
    protected Integer port;

    protected VpnProxyServer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vpnProxyServer";
    }

    /**
     * <i>“Proxy's automatic configuration script url.”</i>
     * 
     * @return property automaticConfigurationScriptUrl
     */
    @Property(name="automaticConfigurationScriptUrl")
    @JsonIgnore
    public Optional<String> getAutomaticConfigurationScriptUrl() {
        return Optional.ofNullable(automaticConfigurationScriptUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * automaticConfigurationScriptUrl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Proxy's automatic configuration script url.”</i>
     * 
     * @param automaticConfigurationScriptUrl
     *            new value of {@code automaticConfigurationScriptUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code automaticConfigurationScriptUrl} field changed
     */
    public VpnProxyServer withAutomaticConfigurationScriptUrl(String automaticConfigurationScriptUrl) {
        VpnProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnProxyServer");
        _x.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
        return _x;
    }

    /**
     * <i>“Address.”</i>
     * 
     * @return property address
     */
    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code address} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Address.”</i>
     * 
     * @param address
     *            new value of {@code address} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code address} field changed
     */
    public VpnProxyServer withAddress(String address) {
        VpnProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnProxyServer");
        _x.address = address;
        return _x;
    }

    /**
     * <i>“Port. Valid values 0 to 65535”</i>
     * 
     * @return property port
     */
    @Property(name="port")
    @JsonIgnore
    public Optional<Integer> getPort() {
        return Optional.ofNullable(port);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code port} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Port. Valid values 0 to 65535”</i>
     * 
     * @param port
     *            new value of {@code port} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code port} field changed
     */
    public VpnProxyServer withPort(Integer port) {
        VpnProxyServer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnProxyServer");
        _x.port = port;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String automaticConfigurationScriptUrl;
        private String address;
        private Integer port;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Proxy's automatic configuration script url.”</i>
         * 
         * @param automaticConfigurationScriptUrl
         *            value of {@code automaticConfigurationScriptUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder automaticConfigurationScriptUrl(String automaticConfigurationScriptUrl) {
            this.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
            this.changedFields = changedFields.add("automaticConfigurationScriptUrl");
            return this;
        }

        /**
         * <i>“Address.”</i>
         * 
         * @param address
         *            value of {@code address} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        /**
         * <i>“Port. Valid values 0 to 65535”</i>
         * 
         * @param port
         *            value of {@code port} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder port(Integer port) {
            this.port = port;
            this.changedFields = changedFields.add("port");
            return this;
        }

        public VpnProxyServer build() {
            VpnProxyServer _x = new VpnProxyServer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.vpnProxyServer";
            _x.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
            _x.address = address;
            _x.port = port;
            return _x;
        }
    }

    private VpnProxyServer _copy() {
        VpnProxyServer _x = new VpnProxyServer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.automaticConfigurationScriptUrl = automaticConfigurationScriptUrl;
        _x.address = address;
        _x.port = port;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VpnProxyServer[");
        b.append("automaticConfigurationScriptUrl=");
        b.append(this.automaticConfigurationScriptUrl);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("port=");
        b.append(this.port);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
