package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“VPN DNS Rule definition.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "servers", 
    "proxyServerUri", 
    "autoTrigger", 
    "persistent"})
@JsonInclude(Include.NON_NULL)
public class VpnDnsRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("servers")
    protected List<String> servers;

    @JsonProperty("servers@nextLink")
    protected String serversNextLink;

    @JsonProperty("proxyServerUri")
    protected String proxyServerUri;

    @JsonProperty("autoTrigger")
    protected Boolean autoTrigger;

    @JsonProperty("persistent")
    protected Boolean persistent;

    protected VpnDnsRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vpnDnsRule";
    }

    /**
     * <i>“Name.”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name.”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public VpnDnsRule withName(String name) {
        VpnDnsRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnDnsRule");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Servers.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<String> getServers() {
        return new CollectionPage<String>(contextPath, String.class, servers, Optional.ofNullable(serversNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Servers.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<String> getServers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, servers, Optional.ofNullable(serversNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Proxy Server Uri.”</i>
     * 
     * @return property proxyServerUri
     */
    @Property(name="proxyServerUri")
    @JsonIgnore
    public Optional<String> getProxyServerUri() {
        return Optional.ofNullable(proxyServerUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxyServerUri}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy Server Uri.”</i>
     * 
     * @param proxyServerUri
     *            new value of {@code proxyServerUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyServerUri} field changed
     */
    public VpnDnsRule withProxyServerUri(String proxyServerUri) {
        VpnDnsRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnDnsRule");
        _x.proxyServerUri = proxyServerUri;
        return _x;
    }

    /**
     * <i>“Automatically connect to the VPN when the device connects to this domain:
     * Default False.”</i>
     * 
     * @return property autoTrigger
     */
    @Property(name="autoTrigger")
    @JsonIgnore
    public Optional<Boolean> getAutoTrigger() {
        return Optional.ofNullable(autoTrigger);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code autoTrigger}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Automatically connect to the VPN when the device connects to this domain:
     * Default False.”</i>
     * 
     * @param autoTrigger
     *            new value of {@code autoTrigger} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoTrigger} field changed
     */
    public VpnDnsRule withAutoTrigger(Boolean autoTrigger) {
        VpnDnsRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnDnsRule");
        _x.autoTrigger = autoTrigger;
        return _x;
    }

    /**
     * <i>“Keep this rule active even when the VPN is not connected: Default False”</i>
     * 
     * @return property persistent
     */
    @Property(name="persistent")
    @JsonIgnore
    public Optional<Boolean> getPersistent() {
        return Optional.ofNullable(persistent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code persistent} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Keep this rule active even when the VPN is not connected: Default False”</i>
     * 
     * @param persistent
     *            new value of {@code persistent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code persistent} field changed
     */
    public VpnDnsRule withPersistent(Boolean persistent) {
        VpnDnsRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vpnDnsRule");
        _x.persistent = persistent;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private List<String> servers;
        private String serversNextLink;
        private String proxyServerUri;
        private Boolean autoTrigger;
        private Boolean persistent;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name.”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Servers.”</i>
         * 
         * @param servers
         *            value of {@code servers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder servers(List<String> servers) {
            this.servers = servers;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        /**
         * <i>“Servers.”</i>
         * 
         * @param servers
         *            value of {@code servers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder servers(String... servers) {
            return servers(Arrays.asList(servers));
        }

        /**
         * <i>“Servers.”</i>
         * 
         * @param serversNextLink
         *            value of {@code servers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serversNextLink(String serversNextLink) {
            this.serversNextLink = serversNextLink;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        /**
         * <i>“Proxy Server Uri.”</i>
         * 
         * @param proxyServerUri
         *            value of {@code proxyServerUri} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyServerUri(String proxyServerUri) {
            this.proxyServerUri = proxyServerUri;
            this.changedFields = changedFields.add("proxyServerUri");
            return this;
        }

        /**
         * <i>“Automatically connect to the VPN when the device connects to this domain:
         * Default False.”</i>
         * 
         * @param autoTrigger
         *            value of {@code autoTrigger} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoTrigger(Boolean autoTrigger) {
            this.autoTrigger = autoTrigger;
            this.changedFields = changedFields.add("autoTrigger");
            return this;
        }

        /**
         * <i>“Keep this rule active even when the VPN is not connected: Default False”</i>
         * 
         * @param persistent
         *            value of {@code persistent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            this.changedFields = changedFields.add("persistent");
            return this;
        }

        public VpnDnsRule build() {
            VpnDnsRule _x = new VpnDnsRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.vpnDnsRule";
            _x.name = name;
            _x.servers = servers;
            _x.serversNextLink = serversNextLink;
            _x.proxyServerUri = proxyServerUri;
            _x.autoTrigger = autoTrigger;
            _x.persistent = persistent;
            return _x;
        }
    }

    private VpnDnsRule _copy() {
        VpnDnsRule _x = new VpnDnsRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.servers = servers;
        _x.proxyServerUri = proxyServerUri;
        _x.autoTrigger = autoTrigger;
        _x.persistent = persistent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VpnDnsRule[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("proxyServerUri=");
        b.append(this.proxyServerUri);
        b.append(", ");
        b.append("autoTrigger=");
        b.append(this.autoTrigger);
        b.append(", ");
        b.append("persistent=");
        b.append(this.persistent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
