package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "title", 
    "body"})
@JsonInclude(Include.NON_NULL)
public class VisualProperties implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("body")
    protected String body;

    protected VisualProperties() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.visualProperties";
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public VisualProperties withTitle(String title) {
        VisualProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualProperties");
        _x.title = title;
        return _x;
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<String> getBody() {
        return Optional.ofNullable(body);
    }

    public VisualProperties withBody(String body) {
        VisualProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.visualProperties");
        _x.body = body;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String title;
        private String body;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public VisualProperties build() {
            VisualProperties _x = new VisualProperties();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.visualProperties";
            _x.title = title;
            _x.body = body;
            return _x;
        }
    }

    private VisualProperties _copy() {
        VisualProperties _x = new VisualProperties();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.title = title;
        _x.body = body;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VisualProperties[");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
