package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "audioBitsPerSample", 
    "audioChannels", 
    "audioFormat", 
    "audioSamplesPerSecond", 
    "bitrate", 
    "duration", 
    "fourCC", 
    "frameRate", 
    "height", 
    "width"})
@JsonInclude(Include.NON_NULL)
public class Video implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("audioBitsPerSample")
    protected Integer audioBitsPerSample;

    @JsonProperty("audioChannels")
    protected Integer audioChannels;

    @JsonProperty("audioFormat")
    protected String audioFormat;

    @JsonProperty("audioSamplesPerSecond")
    protected Integer audioSamplesPerSecond;

    @JsonProperty("bitrate")
    protected Integer bitrate;

    @JsonProperty("duration")
    protected Long duration;

    @JsonProperty("fourCC")
    protected String fourCC;

    @JsonProperty("frameRate")
    protected Double frameRate;

    @JsonProperty("height")
    protected Integer height;

    @JsonProperty("width")
    protected Integer width;

    protected Video() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.video";
    }

    @Property(name="audioBitsPerSample")
    @JsonIgnore
    public Optional<Integer> getAudioBitsPerSample() {
        return Optional.ofNullable(audioBitsPerSample);
    }

    public Video withAudioBitsPerSample(Integer audioBitsPerSample) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.audioBitsPerSample = audioBitsPerSample;
        return _x;
    }

    @Property(name="audioChannels")
    @JsonIgnore
    public Optional<Integer> getAudioChannels() {
        return Optional.ofNullable(audioChannels);
    }

    public Video withAudioChannels(Integer audioChannels) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.audioChannels = audioChannels;
        return _x;
    }

    @Property(name="audioFormat")
    @JsonIgnore
    public Optional<String> getAudioFormat() {
        return Optional.ofNullable(audioFormat);
    }

    public Video withAudioFormat(String audioFormat) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.audioFormat = audioFormat;
        return _x;
    }

    @Property(name="audioSamplesPerSecond")
    @JsonIgnore
    public Optional<Integer> getAudioSamplesPerSecond() {
        return Optional.ofNullable(audioSamplesPerSecond);
    }

    public Video withAudioSamplesPerSecond(Integer audioSamplesPerSecond) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.audioSamplesPerSecond = audioSamplesPerSecond;
        return _x;
    }

    @Property(name="bitrate")
    @JsonIgnore
    public Optional<Integer> getBitrate() {
        return Optional.ofNullable(bitrate);
    }

    public Video withBitrate(Integer bitrate) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.bitrate = bitrate;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Long> getDuration() {
        return Optional.ofNullable(duration);
    }

    public Video withDuration(Long duration) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.duration = duration;
        return _x;
    }

    @Property(name="fourCC")
    @JsonIgnore
    public Optional<String> getFourCC() {
        return Optional.ofNullable(fourCC);
    }

    public Video withFourCC(String fourCC) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.fourCC = fourCC;
        return _x;
    }

    @Property(name="frameRate")
    @JsonIgnore
    public Optional<Double> getFrameRate() {
        return Optional.ofNullable(frameRate);
    }

    public Video withFrameRate(Double frameRate) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.frameRate = frameRate;
        return _x;
    }

    @Property(name="height")
    @JsonIgnore
    public Optional<Integer> getHeight() {
        return Optional.ofNullable(height);
    }

    public Video withHeight(Integer height) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.height = height;
        return _x;
    }

    @Property(name="width")
    @JsonIgnore
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(width);
    }

    public Video withWidth(Integer width) {
        Video _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.video");
        _x.width = width;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer audioBitsPerSample;
        private Integer audioChannels;
        private String audioFormat;
        private Integer audioSamplesPerSecond;
        private Integer bitrate;
        private Long duration;
        private String fourCC;
        private Double frameRate;
        private Integer height;
        private Integer width;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder audioBitsPerSample(Integer audioBitsPerSample) {
            this.audioBitsPerSample = audioBitsPerSample;
            this.changedFields = changedFields.add("audioBitsPerSample");
            return this;
        }

        public Builder audioChannels(Integer audioChannels) {
            this.audioChannels = audioChannels;
            this.changedFields = changedFields.add("audioChannels");
            return this;
        }

        public Builder audioFormat(String audioFormat) {
            this.audioFormat = audioFormat;
            this.changedFields = changedFields.add("audioFormat");
            return this;
        }

        public Builder audioSamplesPerSecond(Integer audioSamplesPerSecond) {
            this.audioSamplesPerSecond = audioSamplesPerSecond;
            this.changedFields = changedFields.add("audioSamplesPerSecond");
            return this;
        }

        public Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            this.changedFields = changedFields.add("bitrate");
            return this;
        }

        public Builder duration(Long duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder fourCC(String fourCC) {
            this.fourCC = fourCC;
            this.changedFields = changedFields.add("fourCC");
            return this;
        }

        public Builder frameRate(Double frameRate) {
            this.frameRate = frameRate;
            this.changedFields = changedFields.add("frameRate");
            return this;
        }

        public Builder height(Integer height) {
            this.height = height;
            this.changedFields = changedFields.add("height");
            return this;
        }

        public Builder width(Integer width) {
            this.width = width;
            this.changedFields = changedFields.add("width");
            return this;
        }

        public Video build() {
            Video _x = new Video();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.video";
            _x.audioBitsPerSample = audioBitsPerSample;
            _x.audioChannels = audioChannels;
            _x.audioFormat = audioFormat;
            _x.audioSamplesPerSecond = audioSamplesPerSecond;
            _x.bitrate = bitrate;
            _x.duration = duration;
            _x.fourCC = fourCC;
            _x.frameRate = frameRate;
            _x.height = height;
            _x.width = width;
            return _x;
        }
    }

    private Video _copy() {
        Video _x = new Video();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.audioBitsPerSample = audioBitsPerSample;
        _x.audioChannels = audioChannels;
        _x.audioFormat = audioFormat;
        _x.audioSamplesPerSecond = audioSamplesPerSecond;
        _x.bitrate = bitrate;
        _x.duration = duration;
        _x.fourCC = fourCC;
        _x.frameRate = frameRate;
        _x.height = height;
        _x.width = width;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Video[");
        b.append("audioBitsPerSample=");
        b.append(this.audioBitsPerSample);
        b.append(", ");
        b.append("audioChannels=");
        b.append(this.audioChannels);
        b.append(", ");
        b.append("audioFormat=");
        b.append(this.audioFormat);
        b.append(", ");
        b.append("audioSamplesPerSecond=");
        b.append(this.audioSamplesPerSecond);
        b.append(", ");
        b.append("bitrate=");
        b.append(this.bitrate);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("fourCC=");
        b.append(this.fourCC);
        b.append(", ");
        b.append("frameRate=");
        b.append(this.frameRate);
        b.append(", ");
        b.append("height=");
        b.append(this.height);
        b.append(", ");
        b.append("width=");
        b.append(this.width);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
