package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "thumbprint", 
    "subjectName", 
    "issuerName", 
    "issueDate", 
    "expiryDate"})
@JsonInclude(Include.NON_NULL)
public class VerifiedCustomDomainCertificatesMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("thumbprint")
    protected String thumbprint;

    @JsonProperty("subjectName")
    protected String subjectName;

    @JsonProperty("issuerName")
    protected String issuerName;

    @JsonProperty("issueDate")
    protected OffsetDateTime issueDate;

    @JsonProperty("expiryDate")
    protected OffsetDateTime expiryDate;

    protected VerifiedCustomDomainCertificatesMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.verifiedCustomDomainCertificatesMetadata";
    }

    @Property(name="thumbprint")
    @JsonIgnore
    public Optional<String> getThumbprint() {
        return Optional.ofNullable(thumbprint);
    }

    public VerifiedCustomDomainCertificatesMetadata withThumbprint(String thumbprint) {
        VerifiedCustomDomainCertificatesMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedCustomDomainCertificatesMetadata");
        _x.thumbprint = thumbprint;
        return _x;
    }

    @Property(name="subjectName")
    @JsonIgnore
    public Optional<String> getSubjectName() {
        return Optional.ofNullable(subjectName);
    }

    public VerifiedCustomDomainCertificatesMetadata withSubjectName(String subjectName) {
        VerifiedCustomDomainCertificatesMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedCustomDomainCertificatesMetadata");
        _x.subjectName = subjectName;
        return _x;
    }

    @Property(name="issuerName")
    @JsonIgnore
    public Optional<String> getIssuerName() {
        return Optional.ofNullable(issuerName);
    }

    public VerifiedCustomDomainCertificatesMetadata withIssuerName(String issuerName) {
        VerifiedCustomDomainCertificatesMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedCustomDomainCertificatesMetadata");
        _x.issuerName = issuerName;
        return _x;
    }

    @Property(name="issueDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getIssueDate() {
        return Optional.ofNullable(issueDate);
    }

    public VerifiedCustomDomainCertificatesMetadata withIssueDate(OffsetDateTime issueDate) {
        VerifiedCustomDomainCertificatesMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedCustomDomainCertificatesMetadata");
        _x.issueDate = issueDate;
        return _x;
    }

    @Property(name="expiryDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpiryDate() {
        return Optional.ofNullable(expiryDate);
    }

    public VerifiedCustomDomainCertificatesMetadata withExpiryDate(OffsetDateTime expiryDate) {
        VerifiedCustomDomainCertificatesMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.verifiedCustomDomainCertificatesMetadata");
        _x.expiryDate = expiryDate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String thumbprint;
        private String subjectName;
        private String issuerName;
        private OffsetDateTime issueDate;
        private OffsetDateTime expiryDate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            this.changedFields = changedFields.add("thumbprint");
            return this;
        }

        public Builder subjectName(String subjectName) {
            this.subjectName = subjectName;
            this.changedFields = changedFields.add("subjectName");
            return this;
        }

        public Builder issuerName(String issuerName) {
            this.issuerName = issuerName;
            this.changedFields = changedFields.add("issuerName");
            return this;
        }

        public Builder issueDate(OffsetDateTime issueDate) {
            this.issueDate = issueDate;
            this.changedFields = changedFields.add("issueDate");
            return this;
        }

        public Builder expiryDate(OffsetDateTime expiryDate) {
            this.expiryDate = expiryDate;
            this.changedFields = changedFields.add("expiryDate");
            return this;
        }

        public VerifiedCustomDomainCertificatesMetadata build() {
            VerifiedCustomDomainCertificatesMetadata _x = new VerifiedCustomDomainCertificatesMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.verifiedCustomDomainCertificatesMetadata";
            _x.thumbprint = thumbprint;
            _x.subjectName = subjectName;
            _x.issuerName = issuerName;
            _x.issueDate = issueDate;
            _x.expiryDate = expiryDate;
            return _x;
        }
    }

    private VerifiedCustomDomainCertificatesMetadata _copy() {
        VerifiedCustomDomainCertificatesMetadata _x = new VerifiedCustomDomainCertificatesMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.thumbprint = thumbprint;
        _x.subjectName = subjectName;
        _x.issuerName = issuerName;
        _x.issueDate = issueDate;
        _x.expiryDate = expiryDate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VerifiedCustomDomainCertificatesMetadata[");
        b.append("thumbprint=");
        b.append(this.thumbprint);
        b.append(", ");
        b.append("subjectName=");
        b.append(this.subjectName);
        b.append(", ");
        b.append("issuerName=");
        b.append(this.issuerName);
        b.append(", ");
        b.append("issueDate=");
        b.append(this.issueDate);
        b.append(", ");
        b.append("expiryDate=");
        b.append(this.expiryDate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
