package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ipAddress", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class UserIdentity extends Identity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected UserIdentity() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userIdentity";
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public UserIdentity withIpAddress(String ipAddress) {
        UserIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userIdentity");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public UserIdentity withUserPrincipalName(String userPrincipalName) {
        UserIdentity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userIdentity");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String ipAddress;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public UserIdentity build() {
            UserIdentity _x = new UserIdentity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userIdentity";
            _x.id = id;
            _x.displayName = displayName;
            _x.ipAddress = ipAddress;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    private UserIdentity _copy() {
        UserIdentity _x = new UserIdentity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.ipAddress = ipAddress;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserIdentity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
