package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The user experience analytics insight is the recomendation to improve the user
 * experience analytics score.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "configurationManagerDataConnectorConfigured"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("configurationManagerDataConnectorConfigured")
    protected Boolean configurationManagerDataConnectorConfigured;

    protected UserExperienceAnalyticsSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsSettings";
    }

    /**
     * <i>“True if Tenant attach is configured. If configured then SCCM tenant attached
     * devices will show up in UXA reporting.”</i>
     * 
     * @return property configurationManagerDataConnectorConfigured
     */
    @Property(name="configurationManagerDataConnectorConfigured")
    @JsonIgnore
    public Optional<Boolean> getConfigurationManagerDataConnectorConfigured() {
        return Optional.ofNullable(configurationManagerDataConnectorConfigured);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationManagerDataConnectorConfigured} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“True if Tenant attach is configured. If configured then SCCM tenant attached
     * devices will show up in UXA reporting.”</i>
     * 
     * @param configurationManagerDataConnectorConfigured
     *            new value of {@code configurationManagerDataConnectorConfigured} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationManagerDataConnectorConfigured} field changed
     */
    public UserExperienceAnalyticsSettings withConfigurationManagerDataConnectorConfigured(Boolean configurationManagerDataConnectorConfigured) {
        UserExperienceAnalyticsSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsSettings");
        _x.configurationManagerDataConnectorConfigured = configurationManagerDataConnectorConfigured;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean configurationManagerDataConnectorConfigured;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“True if Tenant attach is configured. If configured then SCCM tenant attached
         * devices will show up in UXA reporting.”</i>
         * 
         * @param configurationManagerDataConnectorConfigured
         *            value of {@code configurationManagerDataConnectorConfigured} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationManagerDataConnectorConfigured(Boolean configurationManagerDataConnectorConfigured) {
            this.configurationManagerDataConnectorConfigured = configurationManagerDataConnectorConfigured;
            this.changedFields = changedFields.add("configurationManagerDataConnectorConfigured");
            return this;
        }

        public UserExperienceAnalyticsSettings build() {
            UserExperienceAnalyticsSettings _x = new UserExperienceAnalyticsSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsSettings";
            _x.configurationManagerDataConnectorConfigured = configurationManagerDataConnectorConfigured;
            return _x;
        }
    }

    private UserExperienceAnalyticsSettings _copy() {
        UserExperienceAnalyticsSettings _x = new UserExperienceAnalyticsSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.configurationManagerDataConnectorConfigured = configurationManagerDataConnectorConfigured;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsSettings[");
        b.append("configurationManagerDataConnectorConfigured=");
        b.append(this.configurationManagerDataConnectorConfigured);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
