package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.UserExperienceAnalyticsInsightSeverity;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The user experience analytics insight is the recomendation to improve the user
 * experience analytics score.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userExperienceAnalyticsMetricId", 
    "insightId", 
    "values", 
    "severity"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsInsight implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("userExperienceAnalyticsMetricId")
    protected String userExperienceAnalyticsMetricId;

    @JsonProperty("insightId")
    protected String insightId;

    @JsonProperty("values")
    protected List<UserExperienceAnalyticsInsightValue> values;

    @JsonProperty("values@nextLink")
    protected String valuesNextLink;

    @JsonProperty("severity")
    protected UserExperienceAnalyticsInsightSeverity severity;

    protected UserExperienceAnalyticsInsight() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsInsight";
    }

    /**
     * <i>“The unique identifier of the user experience analytics insight.”</i>
     * 
     * @return property userExperienceAnalyticsMetricId
     */
    @Property(name="userExperienceAnalyticsMetricId")
    @JsonIgnore
    public Optional<String> getUserExperienceAnalyticsMetricId() {
        return Optional.ofNullable(userExperienceAnalyticsMetricId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userExperienceAnalyticsMetricId} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The unique identifier of the user experience analytics insight.”</i>
     * 
     * @param userExperienceAnalyticsMetricId
     *            new value of {@code userExperienceAnalyticsMetricId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userExperienceAnalyticsMetricId} field changed
     */
    public UserExperienceAnalyticsInsight withUserExperienceAnalyticsMetricId(String userExperienceAnalyticsMetricId) {
        UserExperienceAnalyticsInsight _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsInsight");
        _x.userExperienceAnalyticsMetricId = userExperienceAnalyticsMetricId;
        return _x;
    }

    /**
     * <i>“The unique identifier of the user experience analytics insight.”</i>
     * 
     * @return property insightId
     */
    @Property(name="insightId")
    @JsonIgnore
    public Optional<String> getInsightId() {
        return Optional.ofNullable(insightId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code insightId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The unique identifier of the user experience analytics insight.”</i>
     * 
     * @param insightId
     *            new value of {@code insightId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code insightId} field changed
     */
    public UserExperienceAnalyticsInsight withInsightId(String insightId) {
        UserExperienceAnalyticsInsight _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsInsight");
        _x.insightId = insightId;
        return _x;
    }

    /**
     * <i>“The value of the user experience analytics insight.”</i>
     * 
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<UserExperienceAnalyticsInsightValue> getValues() {
        return new CollectionPage<UserExperienceAnalyticsInsightValue>(contextPath, UserExperienceAnalyticsInsightValue.class, values, Optional.ofNullable(valuesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The value of the user experience analytics insight.”</i>
     * 
     * @return property values
     */
    @Property(name="values")
    @JsonIgnore
    public CollectionPage<UserExperienceAnalyticsInsightValue> getValues(HttpRequestOptions options) {
        return new CollectionPage<UserExperienceAnalyticsInsightValue>(contextPath, UserExperienceAnalyticsInsightValue.class, values, Optional.ofNullable(valuesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The value of the user experience analytics insight.”</i>
     * 
     * @return property severity
     */
    @Property(name="severity")
    @JsonIgnore
    public Optional<UserExperienceAnalyticsInsightSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code severity} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value of the user experience analytics insight.”</i>
     * 
     * @param severity
     *            new value of {@code severity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code severity} field changed
     */
    public UserExperienceAnalyticsInsight withSeverity(UserExperienceAnalyticsInsightSeverity severity) {
        UserExperienceAnalyticsInsight _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsInsight");
        _x.severity = severity;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String userExperienceAnalyticsMetricId;
        private String insightId;
        private List<UserExperienceAnalyticsInsightValue> values;
        private String valuesNextLink;
        private UserExperienceAnalyticsInsightSeverity severity;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The unique identifier of the user experience analytics insight.”</i>
         * 
         * @param userExperienceAnalyticsMetricId
         *            value of {@code userExperienceAnalyticsMetricId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userExperienceAnalyticsMetricId(String userExperienceAnalyticsMetricId) {
            this.userExperienceAnalyticsMetricId = userExperienceAnalyticsMetricId;
            this.changedFields = changedFields.add("userExperienceAnalyticsMetricId");
            return this;
        }

        /**
         * <i>“The unique identifier of the user experience analytics insight.”</i>
         * 
         * @param insightId
         *            value of {@code insightId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder insightId(String insightId) {
            this.insightId = insightId;
            this.changedFields = changedFields.add("insightId");
            return this;
        }

        /**
         * <i>“The value of the user experience analytics insight.”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(List<UserExperienceAnalyticsInsightValue> values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        /**
         * <i>“The value of the user experience analytics insight.”</i>
         * 
         * @param values
         *            value of {@code values} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder values(UserExperienceAnalyticsInsightValue... values) {
            return values(Arrays.asList(values));
        }

        /**
         * <i>“The value of the user experience analytics insight.”</i>
         * 
         * @param valuesNextLink
         *            value of {@code values@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("values");
            return this;
        }

        /**
         * <i>“The value of the user experience analytics insight.”</i>
         * 
         * @param severity
         *            value of {@code severity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder severity(UserExperienceAnalyticsInsightSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        public UserExperienceAnalyticsInsight build() {
            UserExperienceAnalyticsInsight _x = new UserExperienceAnalyticsInsight();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsInsight";
            _x.userExperienceAnalyticsMetricId = userExperienceAnalyticsMetricId;
            _x.insightId = insightId;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            _x.severity = severity;
            return _x;
        }
    }

    private UserExperienceAnalyticsInsight _copy() {
        UserExperienceAnalyticsInsight _x = new UserExperienceAnalyticsInsight();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.userExperienceAnalyticsMetricId = userExperienceAnalyticsMetricId;
        _x.insightId = insightId;
        _x.values = values;
        _x.severity = severity;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsInsight[");
        b.append("userExperienceAnalyticsMetricId=");
        b.append(this.userExperienceAnalyticsMetricId);
        b.append(", ");
        b.append("insightId=");
        b.append(this.insightId);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
