package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "productType", 
    "lastActivatedDate", 
    "windows", 
    "mac", 
    "windows10Mobile", 
    "ios", 
    "android", 
    "activatedOnSharedComputer"})
@JsonInclude(Include.NON_NULL)
public class UserActivationCounts implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("productType")
    protected String productType;

    @JsonProperty("lastActivatedDate")
    protected LocalDate lastActivatedDate;

    @JsonProperty("windows")
    protected Long windows;

    @JsonProperty("mac")
    protected Long mac;

    @JsonProperty("windows10Mobile")
    protected Long windows10Mobile;

    @JsonProperty("ios")
    protected Long ios;

    @JsonProperty("android")
    protected Long android;

    @JsonProperty("activatedOnSharedComputer")
    protected Boolean activatedOnSharedComputer;

    protected UserActivationCounts() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userActivationCounts";
    }

    @Property(name="productType")
    @JsonIgnore
    public Optional<String> getProductType() {
        return Optional.ofNullable(productType);
    }

    public UserActivationCounts withProductType(String productType) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.productType = productType;
        return _x;
    }

    @Property(name="lastActivatedDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivatedDate() {
        return Optional.ofNullable(lastActivatedDate);
    }

    public UserActivationCounts withLastActivatedDate(LocalDate lastActivatedDate) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.lastActivatedDate = lastActivatedDate;
        return _x;
    }

    @Property(name="windows")
    @JsonIgnore
    public Optional<Long> getWindows() {
        return Optional.ofNullable(windows);
    }

    public UserActivationCounts withWindows(Long windows) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.windows = windows;
        return _x;
    }

    @Property(name="mac")
    @JsonIgnore
    public Optional<Long> getMac() {
        return Optional.ofNullable(mac);
    }

    public UserActivationCounts withMac(Long mac) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.mac = mac;
        return _x;
    }

    @Property(name="windows10Mobile")
    @JsonIgnore
    public Optional<Long> getWindows10Mobile() {
        return Optional.ofNullable(windows10Mobile);
    }

    public UserActivationCounts withWindows10Mobile(Long windows10Mobile) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.windows10Mobile = windows10Mobile;
        return _x;
    }

    @Property(name="ios")
    @JsonIgnore
    public Optional<Long> getIos() {
        return Optional.ofNullable(ios);
    }

    public UserActivationCounts withIos(Long ios) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.ios = ios;
        return _x;
    }

    @Property(name="android")
    @JsonIgnore
    public Optional<Long> getAndroid() {
        return Optional.ofNullable(android);
    }

    public UserActivationCounts withAndroid(Long android) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.android = android;
        return _x;
    }

    @Property(name="activatedOnSharedComputer")
    @JsonIgnore
    public Optional<Boolean> getActivatedOnSharedComputer() {
        return Optional.ofNullable(activatedOnSharedComputer);
    }

    public UserActivationCounts withActivatedOnSharedComputer(Boolean activatedOnSharedComputer) {
        UserActivationCounts _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userActivationCounts");
        _x.activatedOnSharedComputer = activatedOnSharedComputer;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String productType;
        private LocalDate lastActivatedDate;
        private Long windows;
        private Long mac;
        private Long windows10Mobile;
        private Long ios;
        private Long android;
        private Boolean activatedOnSharedComputer;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder productType(String productType) {
            this.productType = productType;
            this.changedFields = changedFields.add("productType");
            return this;
        }

        public Builder lastActivatedDate(LocalDate lastActivatedDate) {
            this.lastActivatedDate = lastActivatedDate;
            this.changedFields = changedFields.add("lastActivatedDate");
            return this;
        }

        public Builder windows(Long windows) {
            this.windows = windows;
            this.changedFields = changedFields.add("windows");
            return this;
        }

        public Builder mac(Long mac) {
            this.mac = mac;
            this.changedFields = changedFields.add("mac");
            return this;
        }

        public Builder windows10Mobile(Long windows10Mobile) {
            this.windows10Mobile = windows10Mobile;
            this.changedFields = changedFields.add("windows10Mobile");
            return this;
        }

        public Builder ios(Long ios) {
            this.ios = ios;
            this.changedFields = changedFields.add("ios");
            return this;
        }

        public Builder android(Long android) {
            this.android = android;
            this.changedFields = changedFields.add("android");
            return this;
        }

        public Builder activatedOnSharedComputer(Boolean activatedOnSharedComputer) {
            this.activatedOnSharedComputer = activatedOnSharedComputer;
            this.changedFields = changedFields.add("activatedOnSharedComputer");
            return this;
        }

        public UserActivationCounts build() {
            UserActivationCounts _x = new UserActivationCounts();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.userActivationCounts";
            _x.productType = productType;
            _x.lastActivatedDate = lastActivatedDate;
            _x.windows = windows;
            _x.mac = mac;
            _x.windows10Mobile = windows10Mobile;
            _x.ios = ios;
            _x.android = android;
            _x.activatedOnSharedComputer = activatedOnSharedComputer;
            return _x;
        }
    }

    private UserActivationCounts _copy() {
        UserActivationCounts _x = new UserActivationCounts();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.productType = productType;
        _x.lastActivatedDate = lastActivatedDate;
        _x.windows = windows;
        _x.mac = mac;
        _x.windows10Mobile = windows10Mobile;
        _x.ios = ios;
        _x.android = android;
        _x.activatedOnSharedComputer = activatedOnSharedComputer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserActivationCounts[");
        b.append("productType=");
        b.append(this.productType);
        b.append(", ");
        b.append("lastActivatedDate=");
        b.append(this.lastActivatedDate);
        b.append(", ");
        b.append("windows=");
        b.append(this.windows);
        b.append(", ");
        b.append("mac=");
        b.append(this.mac);
        b.append(", ");
        b.append("windows10Mobile=");
        b.append(this.windows10Mobile);
        b.append(", ");
        b.append("ios=");
        b.append(this.ios);
        b.append(", ");
        b.append("android=");
        b.append(this.android);
        b.append(", ");
        b.append("activatedOnSharedComputer=");
        b.append(this.activatedOnSharedComputer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
