package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastAccessedDateTime", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class UsageDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastAccessedDateTime")
    protected OffsetDateTime lastAccessedDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected UsageDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.usageDetails";
    }

    @Property(name="lastAccessedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastAccessedDateTime() {
        return Optional.ofNullable(lastAccessedDateTime);
    }

    public UsageDetails withLastAccessedDateTime(OffsetDateTime lastAccessedDateTime) {
        UsageDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usageDetails");
        _x.lastAccessedDateTime = lastAccessedDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public UsageDetails withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        UsageDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.usageDetails");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastAccessedDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder lastAccessedDateTime(OffsetDateTime lastAccessedDateTime) {
            this.lastAccessedDateTime = lastAccessedDateTime;
            this.changedFields = changedFields.add("lastAccessedDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public UsageDetails build() {
            UsageDetails _x = new UsageDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.usageDetails";
            _x.lastAccessedDateTime = lastAccessedDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    private UsageDetails _copy() {
        UsageDetails _x = new UsageDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.lastAccessedDateTime = lastAccessedDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UsageDetails[");
        b.append("lastAccessedDateTime=");
        b.append(this.lastAccessedDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
